% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rprior.R
\name{quantile_to_gev}
\alias{quantile_to_gev}
\title{Converts quantiles to GEV parameters}
\usage{
quantile_to_gev(quant, prob)
}
\arguments{
\item{quant}{A numeric vector of length 3. Values of the quantiles.
The values should \emph{increase} with the index of the vector.
If not, the values in \code{quant} will be sorted into increasing order
without warning.}

\item{prob}{A numeric vector of length 3. Exceedance probabilities
corresponding to the quantiles in \code{quant}.
The values should \emph{decrease} with the index of the vector.
If not, the values in \code{prob} will be sorted into decreasing order
without warning.}
}
\value{
A numeric vector of length 3 containing the GEV location, scale and
  shape parameters.
}
\description{
Three quantiles, that is, the value of quantile and their respective
exceedance probabilities, are provided. This function attempts to
find the location, scale and shape parameters of a GEV distribution that
has these quantiles.
}
\details{
Suppose that \eqn{G(x)} is the distribution function of
  a GEV(\eqn{\mu, \sigma, \xi}) distribution.  This function attempts to
  solve numerically the set of three non-linear equations
  \deqn{G(q[i]) = 1 - p[i], i = 1, 2, 3}
  where \eqn{q[i], i=1,2,3} are the quantiles in \code{quant} and
  \eqn{p[i], i=1,2,3} are the exceedance probabilities in \code{prob}.
  This is reduced to a one-dimensional optimisation over the GEV
  shape parameter.
}
\examples{
my_q <- c(15, 20, 22.5)
my_p <- 1-c(0.5, 0.9, 0.5^0.01)
x <- quantile_to_gev(quant = my_q, prob = my_p)
# Check
qgev(p = 1 - my_p, loc = x[1], scale = x[2], shape = x[3])
}
\seealso{
\code{\link{rprior_quant}} for simulation of GEV parameters from
  a prior constructed on the quantile scale.
}
