% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.r
\name{evalmany}
\alias{evalmany}
\title{Repeated evaluations (Backwards Compatibility)}
\usage{
evalmany(
  fun,
  ...,
  method = c("ofat", "permute", "set"),
  sample = 0L,
  default.args = list(),
  collate = TRUE,
  collate.id = c("single", "multi"),
  collate.prepend = "",
  collate.fun = identity,
  clusters = 1L,
  packages = NULL
)
}
\arguments{
\item{fun}{The function to be evaluated.}

\item{...}{Arguments to be varied when evaluating \code{fun}, where each 
argument in '\code{...}' is a (named) vector or list of values. Lists of
multi-value objects (e.g. data.frames) should be named explicitly and may 
otherwise produce unexpected or incorrect names.}

\item{method}{The sensitivity analysis method to be used. Can be either 
one-factor-at-a-time ("ofat") evaluation, evaluation of parameter sets
("set"), or (sampled) permutations of parameter sets ("permute"). When
\code{method = "ofat"}, the first element of each argument in '\code{...}'
is assumed to be the "default" value of that argument.}

\item{sample}{If \code{method = "permute"}, the number of parameter 
permutations to evaluate (sampling without replacement). 
If \code{sample < 1} (the default) then all possible permutations are 
evaluated.}

\item{default.args}{Named list of additional arguments passed to \code{fun}.}

\item{collate}{Whether to collate the results or not. If \code{TRUE}, output 
elements will be coerced into data.frames using \code{as.data.frame}.
Otherwise, the raw outputs will be returned as a named list.}

\item{collate.id}{If \code{collate = TRUE}, the method used to 
store the evaluation identifiers. If \code{collate.id = "single"}, a 
single column named 'id' is used. If \code{collate.id = "multi"}, 
one column is created for each argument in '\code{...}', e.g. 
'arg1', 'arg2', etc.}

\item{collate.prepend}{A character string prepended to the identifier 
column. If \code{collate.id = "single"}, the identifier column will be
named \code{<collate.prepend>id}. If \code{collate.id = "multi"}, 
identifier columns will be named as \code{<collate.prepend><arg>} where
\code{arg} is an element of '\code{...}'.}

\item{collate.fun}{If \code{collate = TRUE}, an optional function 
for reshaping the output of each evaluation prior to coercing and 
collating the outputs.}

\item{clusters}{Number of clusters to use for parallel (multisession)
processing. Default is 1 (serial computation).}

\item{packages}{Not used, included for backwards compatibility.}
}
\value{
If \code{collate = TRUE}, a data.frame. Otherwise, a named list.
}
\description{
Evaluate a function repeatedly across argument sets or permutations. This
function is included for backwards compatibility with prior
versions of `package:reval` and will be defunct in future releases.
}
