% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/getPartialGamelog.R
\docType{data}
\name{getPartialGamelog}
\alias{gamelogFields}
\alias{getPartialGamelog}
\title{Partial parser for game-log files}
\format{\preformatted{ chr [1:161] "Date" "DblHdr" "Day" "VisTm" "VisTmLg" ...
}}
\usage{
getPartialGamelog(year, glFields, date = NULL, ...)

gamelogFields
}
\arguments{
\item{year}{A single four-digit year.}

\item{glFields}{character.  The desired game-log columns.  This should be a
subset of \code{gamelogFields}, and \strong{not} the entire vector.}

\item{date}{One of either NULL (the default), or a single four-digit
character string identifying the date 'mmdd'}

\item{...}{further arguments passed to \code{\link[utils]{download.file}}}
}
\value{
\itemize{
\item{\code{getPartialGamelog}}{ - A data table with dimensions \code{length(date)} x \code{length(glFields)} if
\code{date} is not NULL, otherwise the row dimension is the nuber of games for the given year.}
\item{\code{gamelogFields}}{ - A character vector of possible values to choose from for the
\code{glFlields} argument in \code{getPartialGamelog}.}
}
}
\description{
Instead of returning the entire file, this function allows the user
to choose the columns and date for game-log data.
}
\examples{
## Get Homerun and RBI info for August 25, 2012, with ballpark ID
f <- grep("HR|RBI|Park", gamelogFields, value = TRUE)
getPartialGamelog(2012, glFields = f, date = "0825")
}
\keyword{datasets}

