% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survey.R, R/survey_df.R
\name{is.survey_df}
\alias{is.survey_df}
\alias{survey_df}
\alias{print.survey_df}
\title{Create a survey object}
\usage{
is.survey_df(x)

survey_df(
  x,
  title = NULL,
  creator = person("Unknown", "Creator"),
  dataset_bibentry = NULL,
  dataset_subject = NULL,
  identifier,
  filename
)

is.survey_df(x)

\method{print}{survey_df}(x, ...)
}
\arguments{
\item{x}{A data frame or tibble containing the survey data.}

\item{title}{Optional title for the survey. Defaults to `"Untitled Survey"`.}

\item{creator}{A [utils::person()] object describing the dataset creator.
Defaults to `person("Unknown", "Creator")`.}

\item{dataset_bibentry}{Optional dataset-level bibliographic metadata.
If `NULL`, a minimal DataCite entry is created automatically using
`title`, `creator`, and `dataset_subject`.}

\item{dataset_subject}{Dataset subject metadata.
If `NULL`, defaults to the Library of Congress Subject Heading
\href{https://id.loc.gov/authorities/subjects/sh85130875}{Surveys}.}

\item{identifier}{A character scalar identifying the survey.}

\item{filename}{A character scalar giving the source filename, or `NULL`
if unknown.}

\item{...}{potentially further arguments for methods.}
}
\value{
An object of class `"survey_df"`, which is a data frame with additional
survey-level metadata stored as attributes and dataset-level metadata
stored using the `dataset` package.
}
\description{
Construct a survey object from a data frame or tibble by attaching
survey-level metadata such as an identifier, source filename, and
basic dataset-level descriptive metadata.
}
\details{
This function is primarily intended for use by import helpers such as
[read_rds()], [read_spss()], [read_dta()], and [read_csv()].
Most users will not need to call it directly.
}
\examples{
survey_df(
  x = data.frame(
    rowid = 1:6,
    observations = runif(6)
  ),
  identifier = "example",
  filename = "no_file"
)

}
\seealso{
[read_survey()] for importing survey data from external files.

Other importing functions: 
\code{\link{survey}()}
}
\concept{importing functions}
