% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_codebook.R
\name{create_codebook}
\alias{create_codebook}
\alias{codebook_waves_create}
\title{Create a codebook}
\usage{
create_codebook(metadata = NULL, survey = NULL)

codebook_waves_create(waves)
}
\arguments{
\item{metadata}{A metadata table created by \code{\link{metadata_create}}. Defaults to \code{NULL}.}

\item{survey}{A survey data frame, defaults to \code{NULL}. If the survey is
given as parameter, the metadata will be set to the metadata of this particular
survey by \code{\link{metadata_create}}.}

\item{waves}{A list of surveys.}
}
\value{
A codebook for the survey as a data frame, including the metadata, and all found 
SPSS-type valid or missing labels.
}
\description{
Create a codebook from one or more survey data files.
}
\details{
For a list of survey waves, use \code{codebook_waves_create}.
The returned codebook contains only labelled variables, i.e., numeric and
character types are not included, because they do not require coding.
}
\examples{
create_codebook (
 survey = read_rds (
          system.file("examples", "ZA7576.rds",
                      package = "retroharmonize")
          )
)
\donttest{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_list <- dir(examples_dir)[grepl("\\\\.rds", dir(examples_dir))]

example_surveys <- read_surveys(
  file.path( examples_dir, survey_list), 
  save_to_rds = FALSE)     

codebook_waves_create (example_surveys)
}
}
\seealso{
Other metadata functions: 
\code{\link{metadata_create}()}

Other metadata functions: 
\code{\link{metadata_create}()}
}
\concept{metadata functions}
