% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_hypothesis_tests.R
\name{retrodesign.numeric}
\alias{retrodesign.numeric}
\title{Numeric retrodesign}
\usage{
\method{retrodesign}{numeric}(A, s, alpha = 0.05, df = Inf,
  n.sims = 10000)
}
\arguments{
\item{A}{a numeric, an estimate of the true effect size}

\item{s}{a numeric, standard error of the estimate}

\item{alpha}{a numeric, the statistical significance threshold}

\item{df}{a numeric, the degrees of freedom. df=Inf is equivalent
to a normal distribution.}

\item{n.sims}{a numeric, how many times to simulate when calculating Type M
error}
}
\value{
A list of length 3 containing the power, type s, and type M
error.
}
\description{
retrodesign.numeric is the S3 method of the generic retrodesign() function,
used when a single numeric is passed for A.
}
\examples{
retrodesign(1,3.28)
retrodesign(2,8.1)
retrodesign(.5,1,df=10)
}
