/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.objectives;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.constraints.Constraint;
import org.restopt.RestoptProblem;
import org.restopt.choco.PropIIC;
import org.restopt.exception.RestoptException;
import org.restopt.grid.neighborhood.INeighborhood;
import org.restopt.grid.neighborhood.Neighborhoods;
import org.restopt.grid.regular.square.GroupedGrid;
import org.restopt.objectives.AbstractRestoptObjective;

public class IntegralIndexOfConnectivityObjective
extends AbstractRestoptObjective {
    public static final String KEY_IIC_INITIAL = "iic_initial";
    public static final String KEY_IIC = "iic";
    public static final String KEY_IIC_BEST = "iic_best";
    int precision;
    double initialValue;
    int distanceThreshold;

    public IntegralIndexOfConnectivityObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, int precision) throws RestoptException {
        this(problem, timeLimit, verbose, maximize, precision, 1, "", false);
    }

    public IntegralIndexOfConnectivityObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, int precision, int distanceThreshold, String search, boolean lns) throws RestoptException {
        super(problem, timeLimit, verbose, maximize, search, lns);
        this.precision = precision;
        if (distanceThreshold < 1) {
            throw new RestoptException("The distance threshold for the integral index of connectivity must be at leastequal to 1");
        }
        this.distanceThreshold = distanceThreshold;
    }

    public IntegralIndexOfConnectivityObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, int precision, int distanceThreshold) throws RestoptException {
        this(problem, timeLimit, verbose, maximize, precision, distanceThreshold, "", false);
    }

    private INeighborhood getNeighborhood() {
        if (this.distanceThreshold == 1) {
            return Neighborhoods.PARTIAL_GROUPED_TWO_WIDE_FOUR_CONNECTED;
        }
        return Neighborhoods.PARTIAL_GROUPED_K_WIDE_FOUR_CONNECTED(this.distanceThreshold + 1);
    }

    @Override
    public void initObjective() {
        GroupedGrid grid = this.problem.getGrid();
        int landscapeArea = this.problem.getLandscapeArea();
        if (this.problem.getAdditionalVariables().containsKey(KEY_IIC)) {
            this.objective = this.problem.getAdditionalVariables().get(KEY_IIC);
            Constraint consIIC = new Constraint("IIC_constraint", new PropIIC(this.problem.getHabitatGraphVar(), this.objective, grid, landscapeArea, this.distanceThreshold + 1, this.precision, true));
            this.initialValue = ((PropIIC)consIIC.getPropagator(0)).getIICLB();
        } else {
            this.objective = this.problem.getModel().intVar("IIC", 0, (int)Math.pow(10.0, this.precision));
            Constraint consIIC = new Constraint("IIC_constraint", new PropIIC(this.problem.getHabitatGraphVar(), this.objective, grid, landscapeArea, this.distanceThreshold + 1, this.precision, true));
            this.problem.getModel().post(consIIC);
            this.initialValue = ((PropIIC)consIIC.getPropagator(0)).getIICLB();
            this.problem.getAdditionalVariables().put(KEY_IIC, this.objective);
        }
    }

    @Override
    public String getInitialValueMessage() {
        return "\nIIC initial = " + this.initialValue + "\n";
    }

    @Override
    public String[] getAdditionalKeys() {
        return new String[]{KEY_IIC_INITIAL, KEY_IIC, KEY_IIC_BEST};
    }

    @Override
    public Map<String, String> appendCharacteristics(Solution solution) {
        HashMap<String, String> charact = new HashMap<String, String>();
        charact.put(KEY_IIC_INITIAL, String.valueOf(1.0 * (double)Math.round(this.initialValue * Math.pow(10.0, this.precision)) / Math.pow(10.0, this.precision)));
        charact.put(KEY_IIC, String.valueOf(1.0 * (double)solution.getIntVal(this.objective) / Math.pow(10.0, this.precision)));
        charact.put(KEY_IIC_BEST, String.valueOf(1.0 * (double)this.getOptimalValue() / Math.pow(10.0, this.precision)));
        return charact;
    }

    @Override
    public List<String[]> appendMessages() {
        ArrayList<String[]> messages = new ArrayList<String[]>();
        messages.add(new String[]{KEY_IIC_INITIAL, "Initial IIC value: "});
        messages.add(new String[]{KEY_IIC, "IIC value: "});
        messages.add(new String[]{KEY_IIC_BEST, "Best known IIC value: "});
        return messages;
    }
}

