/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.nary.automata.FA.ICostAutomaton;
import org.chocosolver.solver.constraints.nary.automata.PropCostRegular;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.chocosolver.solver.constraints.nary.automata.structure.costregular.Arc;
import org.chocosolver.solver.constraints.nary.automata.structure.costregular.StoredValuedDirectedMultiGraph;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;
import org.jgrapht.graph.DirectedMultigraph;

public class CostRegular
extends Constraint {
    public CostRegular(IntVar[] ivars, IntVar cost, ICostAutomaton cautomaton) {
        super("COSTREGULAR", new PropCostRegular(ArrayUtils.concat(ivars, cost), cautomaton, CostRegular.initGraph(ArrayUtils.concat(ivars, cost), cautomaton)));
    }

    private static StoredValuedDirectedMultiGraph initGraph(IntVar[] vars, ICostAutomaton pi) {
        Node o;
        int k;
        TIntIterator layerIter;
        int j;
        int i;
        IEnvironment environment = vars[0].getEnvironment();
        int aid = 0;
        int nid = 0;
        int size = vars.length - 1;
        int[] offsets = new int[size];
        int[] sizes = new int[size];
        int[] starts = new int[size];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            offsets[i2] = vars[i2].getLB();
            sizes[i2] = vars[i2].getUB() - vars[i2].getLB() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(null, null, false);
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        ArrayList<TIntHashSet> layer = new ArrayList<TIntHashSet>();
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= size; ++i) {
            layer.add(new TIntHashSet());
        }
        ((TIntHashSet)layer.get(0)).add(pi.getInitialState());
        TIntHashSet succ = new TIntHashSet();
        for (i = 0; i < size; ++i) {
            int ub = vars[i].getUB();
            j = vars[i].getLB();
            while (j <= ub) {
                layerIter = ((TIntHashSet)layer.get(i)).iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    succ.clear();
                    pi.delta(k, j, succ);
                    if (succ.isEmpty()) continue;
                    TIntIterator it = succ.iterator();
                    while (it.hasNext()) {
                        ((TIntHashSet)layer.get(i + 1)).add(it.next());
                    }
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
                j = vars[i].nextValue(j);
            }
        }
        layerIter = ((TIntHashSet)layer.get(size)).iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (!pi.isNotFinal(k)) continue;
            layerIter.remove();
        }
        int nbNodes = pi.getNbStates();
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[pi.getNbStates() * (size + 1)];
        Node tink = new Node(pi.getNbStates() + 1, size + 1, nid++);
        graph.addVertex(tink);
        for (i = size - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            int ub = vars[i].getUB();
            j = vars[i].getLB();
            while (j <= ub) {
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l != null) {
                    TIntIterator qijIter = l.iterator();
                    while (qijIter.hasNext()) {
                        k = qijIter.next();
                        succ.clear();
                        pi.delta(k, j, succ);
                        TIntIterator it = succ.iterator();
                        boolean added = false;
                        while (it.hasNext()) {
                            Node b;
                            int qn = it.next();
                            if (!((TIntHashSet)layer.get(i + 1)).contains(qn)) continue;
                            added = true;
                            Node a = in[i * pi.getNbStates() + k];
                            if (a == null) {
                                in[i * pi.getNbStates() + k] = a = new Node(k, i, nid++);
                                graph.addVertex(a);
                            }
                            if ((b = in[(i + 1) * pi.getNbStates() + qn]) == null) {
                                in[(i + 1) * pi.getNbStates() + qn] = b = new Node(qn, i + 1, nid++);
                                graph.addVertex(b);
                            }
                            Arc arc = new Arc(a, b, j, aid++, pi.getCostByState(i, j, a.state));
                            graph.addEdge(a, b, arc);
                            ((HashSet)tmp.get(idx)).add(arc);
                            mark.set(k);
                        }
                        if (added) continue;
                        qijIter.remove();
                    }
                }
                j = vars[i].nextValue(j);
            }
            layerIter = ((TIntHashSet)layer.get(i)).iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        TIntHashSet th = new TIntHashSet();
        int[][] intLayer = new int[size + 2][];
        for (k = 0; k < pi.getNbStates(); ++k) {
            o = in[size * pi.getNbStates() + k];
            if (o == null) continue;
            Arc a = new Arc(o, tink, 0, aid++, 0.0);
            graph.addEdge(o, tink, a);
        }
        for (i = 0; i <= size; ++i) {
            th.clear();
            for (k = 0; k < pi.getNbStates(); ++k) {
                o = in[i * pi.getNbStates() + k];
                if (o == null) continue;
                th.add(o.id);
            }
            intLayer[i] = th.toArray();
        }
        intLayer[size + 1] = new int[]{tink.id};
        if (intLayer[0].length > 0) {
            return new StoredValuedDirectedMultiGraph(environment, graph, intLayer, starts, offsets, totalSizes);
        }
        throw new SolverException("intLayer[0].length <= 0");
    }
}

