/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.delta.GraphDelta;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.delta.monitor.GraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.scheduler.GraphEvtScheduler;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public abstract class AbstractGraphVar<E extends IGraph>
extends AbstractVariable
implements GraphVar<E> {
    protected E UB;
    protected E LB;
    protected GraphDelta delta;
    protected int n;
    protected boolean reactOnModification;

    protected AbstractGraphVar(String name, Model solver, E LB, E UB) {
        super(name, solver);
        this.LB = LB;
        this.UB = UB;
        this.n = UB.getNbMaxNodes();
        assert (this.n == LB.getNbMaxNodes());
    }

    @Override
    public boolean isInstantiated() {
        if (this.getPotentialNodes().size() != this.getMandatoryNodes().size()) {
            return false;
        }
        ISetIterator iSetIterator = this.getUB().getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISet suc = this.UB.getSuccessorsOf(i);
            if (suc.size() == this.getLB().getSuccessorsOf(i).size()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeNode(int x, ICause cause) throws ContradictionException {
        assert (cause != null);
        assert (x >= 0 && x < this.n);
        if (this.LB.getNodes().contains(x)) {
            this.contradiction(cause, "remove mandatory node");
            return true;
        }
        if (!this.UB.getNodes().contains(x)) {
            return false;
        }
        int[] succ = this.UB.getSuccessorsOf(x).toArray();
        int[] pred = this.UB.getPredecessorsOf(x).toArray();
        if (this.UB.removeNode(x)) {
            if (this.reactOnModification) {
                this.delta.add(x, 0, cause);
                for (int i : succ) {
                    this.delta.add(x, 2, cause);
                    this.delta.add(i, 3, cause);
                }
                for (int i : pred) {
                    this.delta.add(i, 2, cause);
                    this.delta.add(x, 3, cause);
                }
            }
            if (succ.length > 0 || pred.length > 0) {
                this.notifyPropagators(GraphEventType.REMOVE_EDGE, cause);
            }
            this.notifyPropagators(GraphEventType.REMOVE_NODE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean enforceNode(int x, ICause cause) throws ContradictionException {
        assert (cause != null);
        assert (x >= 0 && x < this.n);
        if (this.UB.getNodes().contains(x)) {
            if (this.LB.addNode(x)) {
                if (this.reactOnModification) {
                    this.delta.add(x, 1, cause);
                }
                this.notifyPropagators(GraphEventType.ADD_NODE, cause);
                return true;
            }
            return false;
        }
        this.contradiction(cause, "enforce node which is not in the domain");
        return true;
    }

    @Override
    public boolean removeEdge(int x, int y, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (this.LB.containsEdge(x, y)) {
            this.contradiction(cause, "remove mandatory edge");
            return false;
        }
        if (this.UB.removeEdge(x, y)) {
            if (this.reactOnModification) {
                this.delta.add(x, 2, cause);
                this.delta.add(y, 3, cause);
            }
            this.notifyPropagators(GraphEventType.REMOVE_EDGE, cause);
            return true;
        }
        return false;
    }

    @Override
    public boolean enforceEdge(int x, int y, ICause cause) throws ContradictionException {
        boolean addY;
        assert (cause != null);
        boolean addX = !this.LB.containsNode(x);
        boolean bl = addY = !this.LB.containsNode(y);
        if (this.UB.containsEdge(x, y)) {
            if (this.LB.addEdge(x, y)) {
                if (this.reactOnModification) {
                    this.delta.add(x, 4, cause);
                    this.delta.add(y, 5, cause);
                    if (addX) {
                        this.delta.add(x, 1, cause);
                    }
                    if (addY) {
                        this.delta.add(y, 1, cause);
                    }
                }
                if (addX || addY) {
                    this.notifyPropagators(GraphEventType.ADD_NODE, cause);
                }
                this.notifyPropagators(GraphEventType.ADD_EDGE, cause);
                return true;
            }
            return false;
        }
        this.contradiction(cause, "enforce edge which is not in the domain");
        return false;
    }

    @Override
    public E getLB() {
        return this.LB;
    }

    @Override
    public E getUB() {
        return this.UB;
    }

    @Override
    public int getNbMaxNodes() {
        return this.n;
    }

    @Override
    public GraphDelta getDelta() {
        return this.delta;
    }

    @Override
    public int getTypeAndKind() {
        return 129;
    }

    public EvtScheduler createScheduler() {
        return new GraphEvtScheduler();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("graph_var ").append(this.getName());
        if (this.isInstantiated()) {
            sb.append("\nValue: \n");
            sb.append(this.UB.toString());
        } else {
            sb.append("\nUpper bound: \n");
            sb.append(this.UB.toString());
            sb.append("\nLower bound: \n");
            sb.append(this.LB.toString());
        }
        return sb.toString();
    }

    @Override
    public void createDelta() {
        if (!this.reactOnModification) {
            this.reactOnModification = true;
            this.delta = new GraphDelta(this.getEnvironment());
        }
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
        assert (cause != null);
        this.model.getSolver().getEngine().onVariableUpdate(this, event, cause);
        this.notifyMonitors(event);
        this.notifyViews(event, cause);
    }

    @Override
    public void instantiateTo(E value, ICause cause) throws ContradictionException {
        int i;
        ISet nodes = value.getNodes();
        for (i = 0; i < this.n; ++i) {
            if (nodes.contains(i)) {
                this.enforceNode(i, cause);
                continue;
            }
            this.removeNode(i, cause);
        }
        for (i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                if (!nodes.contains(i) || !nodes.contains(j)) continue;
                if (value.getSuccessorsOf(i).contains(j)) {
                    this.enforceEdge(i, j, cause);
                    continue;
                }
                this.removeEdge(i, j, cause);
            }
        }
    }

    public boolean[][] getValueAsBoolMatrix() {
        int n = this.getUB().getNbMaxNodes();
        boolean[][] vals = new boolean[n + 1][n];
        ISetIterator iSetIterator = this.getLB().getNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISetIterator iSetIterator2 = this.getLB().getSuccessorsOf(i).iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                vals[i][j] = true;
            }
            vals[n][i] = true;
        }
        return vals;
    }

    @Override
    public void instantiateTo(boolean[][] value, ICause cause) throws ContradictionException {
        int n = value.length - 1;
        for (int i = 0; i < n; ++i) {
            if (value[n][i]) {
                this.enforceNode(i, cause);
            } else {
                this.removeNode(i, cause);
            }
            for (int j = 0; j < n; ++j) {
                if (value[i][j]) {
                    this.enforceEdge(i, j, cause);
                    continue;
                }
                this.removeEdge(i, j, cause);
            }
        }
    }

    @Override
    public IGraphDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new GraphDeltaMonitor(this.getDelta(), propagator);
    }
}

