/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables;

import java.util.Arrays;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.DirectedGraphVar;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.RealView;
import org.chocosolver.solver.variables.view.bool.BoolEqView;
import org.chocosolver.solver.variables.view.bool.BoolLeqView;
import org.chocosolver.solver.variables.view.bool.BoolNotView;
import org.chocosolver.solver.variables.view.bool.BoolSetView;
import org.chocosolver.solver.variables.view.graph.directed.DirectedEdgeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.directed.DirectedGraphUnionView;
import org.chocosolver.solver.variables.view.graph.directed.DirectedNodeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.undirected.EdgeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.undirected.NodeInducedSubgraphView;
import org.chocosolver.solver.variables.view.graph.undirected.UndirectedGraphUnionView;
import org.chocosolver.solver.variables.view.integer.IntMinusView;
import org.chocosolver.solver.variables.view.integer.IntOffsetView;
import org.chocosolver.solver.variables.view.integer.IntScaleView;
import org.chocosolver.solver.variables.view.set.SetBoolsView;
import org.chocosolver.solver.variables.view.set.SetDifferenceView;
import org.chocosolver.solver.variables.view.set.SetIntersectionView;
import org.chocosolver.solver.variables.view.set.SetIntsView;
import org.chocosolver.solver.variables.view.set.SetNodeGraphView;
import org.chocosolver.solver.variables.view.set.SetPredecessorsGraphView;
import org.chocosolver.solver.variables.view.set.SetSuccessorsGraphView;
import org.chocosolver.solver.variables.view.set.SetUnionView;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;

public interface IViewFactory
extends ISelf<Model> {
    default public BoolVar boolNotView(BoolVar bool) {
        BoolVar not;
        if (bool.hasNot()) {
            return bool.not();
        }
        if (bool.isInstantiated()) {
            not = bool.getValue() == 1 ? ((Model)this.ref()).boolVar(false) : ((Model)this.ref()).boolVar(true);
        } else {
            if (((Model)this.ref()).getSettings().enableViews()) {
                not = new BoolNotView<BoolVar>(bool);
            } else {
                not = ((Model)this.ref()).boolVar("not(" + bool.getName() + ")");
                ((Model)this.ref()).arithm(not, "!=", bool).post();
            }
            not.setNot(true);
        }
        bool._setNot(not);
        not._setNot(bool);
        return not;
    }

    default public BoolVar setBoolView(SetVar setVar, int v) {
        return new BoolSetView<SetVar>(v, setVar);
    }

    default public BoolVar[] setBoolsView(SetVar setVar, int size, int offset) {
        BoolVar[] bools = new BoolVar[size];
        for (int i = 0; i < size; ++i) {
            bools[i] = this.setBoolView(setVar, i + offset);
        }
        return bools;
    }

    default public IntVar intOffsetView(IntVar var, int cste) {
        if (cste == 0) {
            return var;
        }
        String name = "(" + var.getName() + (cste >= 0 ? "+" : "-") + Math.abs(cste) + ")";
        if (var.isInstantiated()) {
            return ((Model)this.ref()).intVar(name, var.getValue() + cste);
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(var, cste, IntOffsetView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p > -1) {
                return var.getView(p).asIntVar();
            }
            return new IntOffsetView<IntVar>(var, cste);
        }
        int lb = var.getLB() + cste;
        int ub = var.getUB() + cste;
        IntVar ov = var.hasEnumeratedDomain() ? ((Model)this.ref()).intVar(name, lb, ub, false) : ((Model)this.ref()).intVar(name, lb, ub, true);
        ((Model)this.ref()).arithm(ov, "-", var, "=", cste).post();
        return ov;
    }

    default public IntVar intMinusView(IntVar var) {
        if (var.isInstantiated()) {
            return ((Model)this.ref()).intVar(-var.getValue());
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            if (var instanceof IntMinusView) {
                return ((IntMinusView)var).getVariable();
            }
            int p = IViewFactory.checkDeclaredView(var, -1, IntMinusView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p > -1) {
                return var.getView(p).asIntVar();
            }
            return new IntMinusView<IntVar>(var);
        }
        int ub = -var.getLB();
        int lb = -var.getUB();
        String name = "-(" + var.getName() + ")";
        IntVar ov = var.hasEnumeratedDomain() ? ((Model)this.ref()).intVar(name, lb, ub, false) : ((Model)this.ref()).intVar(name, lb, ub, true);
        ((Model)this.ref()).arithm(ov, "+", var, "=", 0).post();
        return ov;
    }

    default public IntVar intScaleView(IntVar var, int cste) {
        IntVar v2;
        if (cste == -1) {
            return this.intMinusView(var);
        }
        if (cste == 0) {
            v2 = ((Model)this.ref()).intVar(0);
        } else if (cste == 1) {
            v2 = var;
        } else {
            if (var.isInstantiated()) {
                return ((Model)this.ref()).intVar(var.getValue() * cste);
            }
            if (((Model)this.ref()).getSettings().enableViews()) {
                boolean rev = cste < 0;
                int p = IViewFactory.checkDeclaredView(var, cste = Math.abs(cste), IntScaleView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
                if (p > -1) {
                    return var.getView(p).asIntVar();
                }
                v2 = new IntScaleView<IntVar>(var, cste);
                if (rev) {
                    v2 = this.intMinusView(v2);
                }
            } else {
                int ub;
                int lb;
                if (cste > 0) {
                    lb = var.getLB() * cste;
                    ub = var.getUB() * cste;
                } else {
                    lb = var.getUB() * cste;
                    ub = var.getLB() * cste;
                }
                String name = "(" + var.getName() + "*" + cste + ")";
                IntVar ov = var.hasEnumeratedDomain() ? ((Model)this.ref()).intVar(name, lb, ub, false) : ((Model)this.ref()).intVar(name, lb, ub, true);
                ((Model)this.ref()).times(var, cste, ov).post();
                return ov;
            }
        }
        return v2;
    }

    default public IntVar intAbsView(IntVar var) {
        if (var.isInstantiated()) {
            return ((Model)this.ref()).intVar(Math.abs(var.getValue()));
        }
        if (var.getLB() >= 0) {
            return var;
        }
        if (var.getUB() <= 0) {
            return this.intMinusView(var);
        }
        int ub = Math.max(-var.getLB(), var.getUB());
        String name = "|" + var.getName() + "|";
        IntVar abs = var.hasEnumeratedDomain() ? ((Model)this.ref()).intVar(name, 0, ub, false) : ((Model)this.ref()).intVar(name, 0, ub, true);
        ((Model)this.ref()).absolute(abs, var).post();
        return abs;
    }

    default public IntVar intAffineView(int a2, IntVar x, int b) {
        if (x.isInstantiated()) {
            return ((Model)this.ref()).intVar(a2 * x.getValue() + b);
        }
        return this.intOffsetView(this.intScaleView(x, a2), b);
    }

    default public BoolVar intEqView(IntVar x, int c) {
        if (x.isInstantiatedTo(c)) {
            return ((Model)this.ref()).boolVar(true);
        }
        if (!x.contains(c)) {
            return ((Model)this.ref()).boolVar(false);
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(x, c, BoolEqView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p >= 0) {
                return x.getView(p).asBoolVar();
            }
            return new BoolEqView<IntVar>(x, c);
        }
        BoolVar b = ((Model)this.ref()).boolVar();
        ((Model)this.ref()).reifyXeqC(x, c, b);
        return b;
    }

    default public BoolVar intNeView(IntVar x, int c) {
        if (x.isInstantiatedTo(c)) {
            return ((Model)this.ref()).boolVar(false);
        }
        if (!x.contains(c)) {
            return ((Model)this.ref()).boolVar(true);
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(x, c, BoolEqView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p >= 0) {
                return x.getView(p).asBoolVar().not();
            }
            return new BoolEqView<IntVar>(x, c).not();
        }
        BoolVar b = ((Model)this.ref()).boolVar();
        ((Model)this.ref()).reifyXneC(x, c, b);
        return b;
    }

    default public BoolVar intLeView(IntVar x, int c) {
        if (x.getUB() <= c) {
            return ((Model)this.ref()).boolVar(true);
        }
        if (x.getLB() > c) {
            return ((Model)this.ref()).boolVar(false);
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(x, c, BoolLeqView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p >= 0) {
                return x.getView(p).asBoolVar();
            }
            return new BoolLeqView<IntVar>(x, c);
        }
        BoolVar b = ((Model)this.ref()).boolVar();
        ((Model)this.ref()).reifyXltC(x, c + 1, b);
        return b;
    }

    default public BoolVar intGeView(IntVar x, int c) {
        if (x.getLB() >= c) {
            return ((Model)this.ref()).boolVar(true);
        }
        if (x.getUB() < c) {
            return ((Model)this.ref()).boolVar(false);
        }
        if (((Model)this.ref()).getSettings().enableViews()) {
            int p = IViewFactory.checkDeclaredView(x, c - 1, BoolLeqView.class, ((Model)this.ref()).getSettings().checkDeclaredViews());
            if (p >= 0) {
                return x.getView(p).asBoolVar().not();
            }
            return new BoolLeqView<IntVar>(x, c - 1).not();
        }
        BoolVar b = ((Model)this.ref()).boolVar();
        ((Model)this.ref()).reifyXgtC(x, c - 1, b);
        return b;
    }

    public static int checkDeclaredView(IntVar x, int c, Class clazz, boolean check) {
        for (int i = 0; check && i < x.getNbViews(); ++i) {
            IntView v;
            if (!clazz.isInstance(x.getView(i))) continue;
            if (clazz == BoolEqView.class) {
                v = (BoolEqView)x.getView(i);
                if (v.cste != c) continue;
                return i;
            }
            if (clazz == BoolLeqView.class) {
                v = (BoolLeqView)x.getView(i);
                if (((BoolLeqView)v).cste != c) continue;
                return i;
            }
            if (clazz == IntMinusView.class) {
                return i;
            }
            if (clazz == IntOffsetView.class) {
                v = (IntOffsetView)x.getView(i);
                if (((IntOffsetView)v).cste != c) continue;
                return i;
            }
            if (clazz != IntScaleView.class) continue;
            v = (IntScaleView)x.getView(i);
            if (((IntScaleView)v).cste != c) continue;
            return i;
        }
        return -1;
    }

    default public RealVar realIntView(IntVar var, double precision) {
        if (((Model)this.ref()).getSettings().enableViews()) {
            return new RealView<IntVar>(var, precision);
        }
        double lb = var.getLB();
        double ub = var.getUB();
        RealVar rv = ((Model)this.ref()).realVar("(real)" + var.getName(), lb, ub, precision);
        ((Model)this.ref()).realIbexGenericConstraint("{0} = {1}", rv, var).post();
        return rv;
    }

    default public RealVar[] realIntViewArray(IntVar[] ints, double precision) {
        RealVar[] reals = new RealVar[ints.length];
        if (((Model)this.ref()).getSettings().enableViews()) {
            for (int i = 0; i < ints.length; ++i) {
                reals[i] = this.realIntView(ints[i], precision);
            }
        } else {
            for (int i = 0; i < ints.length; ++i) {
                double lb = ints[i].getLB();
                double ub = ints[i].getUB();
                reals[i] = ((Model)this.ref()).realVar("(real)" + ints[i].getName(), lb, ub, precision);
                ((Model)this.ref()).realIbexGenericConstraint("{0} = {1}", reals[i], ints[i]).post();
            }
        }
        return reals;
    }

    default public RealVar[][] realIntViewMatrix(IntVar[][] ints, double precision) {
        RealVar[][] vars = new RealVar[ints.length][ints[0].length];
        for (int i = 0; i < ints.length; ++i) {
            vars[i] = this.realIntViewArray(ints[i], precision);
        }
        return vars;
    }

    default public SetVar boolsSetView(BoolVar[] boolVars, int offset) {
        return new SetBoolsView(offset, boolVars);
    }

    default public SetVar intsSetView(IntVar[] intVars, int[] v, int offset) {
        return new SetIntsView(v, offset, intVars);
    }

    default public SetVar intsSetView(IntVar[] intVars, int v, int offset) {
        int[] vals = new int[intVars.length];
        Arrays.fill(vals, v);
        return this.intsSetView(intVars, vals, offset);
    }

    default public SetVar[] intsSetsView(IntVar[] intVars, int nbSets, int offset1, int offset2) {
        SetVar[] setVars = new SetVar[nbSets];
        for (int i = 0; i < nbSets; ++i) {
            setVars[i] = this.intsSetView(intVars, i + offset1, offset2);
        }
        return setVars;
    }

    default public SetVar setUnionView(SetVar ... sets) {
        return new SetUnionView("setUnion", sets);
    }

    default public SetVar setIntersectionView(SetVar ... sets) {
        return new SetIntersectionView("setIntersection", sets);
    }

    default public SetVar setDifferenceView(SetVar x, SetVar y) {
        return new SetDifferenceView("setDifference", x, y);
    }

    default public SetVar graphNodeSetView(GraphVar<? extends IGraph> g) {
        return new SetNodeGraphView<GraphVar<? extends IGraph>>(g);
    }

    default public SetVar graphSuccessorsSetView(DirectedGraphVar g, int node) {
        return new SetSuccessorsGraphView<DirectedGraphVar>(g, node);
    }

    default public SetVar graphPredecessorsSetView(DirectedGraphVar g, int node) {
        return new SetPredecessorsGraphView<DirectedGraphVar>(g, node);
    }

    default public SetVar graphNeighborsSetView(UndirectedGraphVar g, int node) {
        return new SetSuccessorsGraphView<UndirectedGraphVar>(g, node);
    }

    default public UndirectedGraphVar nodeInducedSubgraphView(UndirectedGraphVar g, ISet nodes, boolean exclude) {
        return new NodeInducedSubgraphView(g.getName() + "[" + nodes.toString() + "]", g, nodes, exclude);
    }

    default public DirectedGraphVar nodeInducedSubgraphView(DirectedGraphVar g, ISet nodes, boolean exclude) {
        return new DirectedNodeInducedSubgraphView(g.getName() + "[" + nodes.toString() + "]", g, nodes, exclude);
    }

    default public UndirectedGraphVar edgeInducedSubgraphView(UndirectedGraphVar g, int[][] edges, boolean exclude) {
        return new EdgeInducedSubgraphView(g.getName() + "{" + Arrays.deepToString((Object[])edges) + "}", g, edges, exclude);
    }

    default public DirectedGraphVar edgeInducedSubgraphView(DirectedGraphVar g, int[][] edges, boolean exclude) {
        return new DirectedEdgeInducedSubgraphView(g.getName() + "{" + Arrays.deepToString((Object[])edges) + "}", g, edges, exclude);
    }

    default public UndirectedGraphVar graphUnionView(UndirectedGraphVar ... graphVars) {
        return new UndirectedGraphUnionView("GraphUnionView", graphVars);
    }

    default public DirectedGraphVar graphUnionView(DirectedGraphVar ... graphVars) {
        return new DirectedGraphUnionView("GraphUnionView", graphVars);
    }
}

