/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.arithmetic;

import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;

public class IfArExpression
implements ArExpression {
    Model model;
    IntVar me = null;
    private final ArExpression e1;
    private final ArExpression e2;
    private final ReExpression b0;

    public IfArExpression(ReExpression b, ArExpression y1, ArExpression y2) {
        this.model = y1.getModel();
        this.b0 = b;
        this.e1 = y1;
        this.e2 = y2;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public IntVar intVar() {
        if (this.me == null) {
            BoolVar v0 = this.b0.boolVar();
            IntVar v1 = this.e1.intVar();
            IntVar v2 = this.e2.intVar();
            this.me = this.model.intVar(this.model.generateName("if_exp_"), Math.min(v1.getLB(), v2.getLB()), Math.max(v1.getUB(), v2.getUB()));
            this.model.reifyXeqY(this.me, v1, v0);
            this.model.reifyXeqY(this.me, v2, v0.not());
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        this.b0.extractVar(variables);
        this.e1.extractVar(variables);
        this.e2.extractVar(variables);
    }

    @Override
    public int ieval(int[] values, Map<IntVar, Integer> map) {
        if (this.b0.beval(values, map)) {
            return this.e1.ieval(values, map);
        }
        return this.e2.ieval(values, map);
    }

    @Override
    public int getNoChild() {
        return 3;
    }

    @Override
    public ArExpression[] getExpressionChild() {
        return new ArExpression[]{this.b0, this.e1, this.e2};
    }

    public String toString() {
        return "IF(" + this.b0.toString() + "," + this.e1.toString() + "," + this.e2.toString() + ")";
    }
}

