/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferent;

import gnu.trove.stack.array.TIntArrayStack;
import java.util.stream.IntStream;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropAllDiffInst
extends Propagator<IntVar> {
    protected final int n;
    protected FastResetArrayStack toCheck = new FastResetArrayStack();

    public PropAllDiffInst(IntVar[] variables) {
        super((Variable[])variables, (Priority)PropagatorPriority.UNARY, true);
        this.n = ((IntVar[])this.vars).length;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.instantiation();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.toCheck.resetQuick();
        for (int v = 0; v < this.n; ++v) {
            if (!((IntVar[])this.vars)[v].isInstantiated()) continue;
            this.toCheck.push(v);
        }
        this.fixpoint();
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.toCheck.resetQuick();
        this.toCheck.push(varIdx);
        this.fixpoint();
    }

    protected void fixpoint() throws ContradictionException {
        while (this.toCheck.size() > 0) {
            int vidx = this.toCheck.pop();
            int val = ((IntVar[])this.vars)[vidx].getValue();
            for (int i = 0; i < this.n; ++i) {
                if (i == vidx || !((IntVar[])this.vars)[i].removeValue(val, this) || !((IntVar[])this.vars)[i].isInstantiated()) continue;
                this.toCheck.push(i);
            }
        }
    }

    @Override
    public ESat isEntailed() {
        int nbInst = 0;
        for (int i = 0; i < this.n; ++i) {
            if (!((IntVar[])this.vars)[i].isInstantiated()) continue;
            ++nbInst;
            for (int j = i + 1; j < this.n; ++j) {
                if (!((IntVar[])this.vars)[j].isInstantiatedTo(((IntVar[])this.vars)[i].getValue())) continue;
                return ESat.FALSE;
            }
        }
        if (nbInst == ((IntVar[])this.vars).length) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private void explainEqualExistit(ExplanationForSignedClause e, int[] indexes, int t) {
        for (int i : indexes) {
            if (!((IntVar[])this.vars)[i].isInstantiatedTo(t)) continue;
            ((IntVar[])this.vars)[i].unionLit(e.complement(((IntVar[])this.vars)[i]), e);
            break;
        }
    }

    @Override
    public void explain(int p, ExplanationForSignedClause e) {
        IntVar pivot = e.readVar(p);
        int[] X = IntStream.rangeClosed(0, ((IntVar[])this.vars).length - 1).filter(i -> ((IntVar[])this.vars)[i] != pivot).toArray();
        switch (e.readMask(p)) {
            case 1: {
                IntIterableRangeSet dbef = e.domain(pivot);
                dbef.removeAll(e.readDom(p));
                int t = dbef.min();
                this.explainEqualExistit(e, X, t);
                IntIterableRangeSet set = e.universe();
                set.remove(t);
                pivot.intersectLit(set, e);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown event type for explanation");
            }
        }
    }

    protected static class FastResetArrayStack
    extends TIntArrayStack {
        protected FastResetArrayStack() {
        }

        void resetQuick() {
            this._list.resetQuick();
        }
    }
}

