/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.chocosolver.solver.ISelf;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.nary.automata.FA.IAutomaton;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public interface IDecompositionFactory
extends ISelf<Model> {
    default public void cumulativeTimeDec(IntVar[] starts, int[] durations, int[] heights, int capacity) {
        int n = starts.length;
        int min_t = Integer.MAX_VALUE;
        int max_t = Integer.MIN_VALUE;
        for (int i = 0; i < n; ++i) {
            min_t = Math.min(min_t, starts[i].getLB());
            max_t = Math.max(max_t, starts[i].getUB() + durations[i]);
        }
        for (int t = min_t; t <= max_t; ++t) {
            IntVar[] bit = ((Model)this.ref()).boolVarArray(String.format("b_%s_", t), n);
            for (int i = 0; i < n; ++i) {
                ((Model)this.ref()).addClausesBoolAndArrayEqVar(new BoolVar[]{((Model)this.ref()).intLeView(starts[i], t), ((Model)this.ref()).intGeView(starts[i], t - durations[i] + 1)}, (BoolVar)bit[i]);
            }
            ((Model)this.ref()).scalar(bit, Arrays.stream(heights, 0, n).toArray(), "<=", capacity).post();
        }
    }

    default public IntVar[] element(IntVar value, int[][] matrix, IntVar rowIndex, int rowOffset, IntVar colIndex, int colOffset) {
        IntVar[] results = new IntVar[matrix.length];
        for (int r = 0; r < matrix.length; ++r) {
            int min = IntStream.of(matrix[r]).min().orElse(-21474836);
            int max = IntStream.of(matrix[r]).max().orElse(21474836);
            results[r] = ((Model)this.ref()).intVar("val[" + r + "]", min, max);
            ((Model)this.ref()).element(results[r], matrix[r], colIndex, colOffset).post();
        }
        ((Model)this.ref()).element(value, results, rowIndex, rowOffset).post();
        return results;
    }

    default public IntVar[] element(IntVar value, IntVar[][] matrix, IntVar rowIndex, int rowOffset, IntVar colIndex, int colOffset) {
        IntVar[] results = new IntVar[matrix.length];
        for (int r = 0; r < matrix.length; ++r) {
            int min = Stream.of(matrix[r]).mapToInt(IntVar::getLB).min().orElse(-21474836);
            int max = Stream.of(matrix[r]).mapToInt(IntVar::getUB).max().orElse(21474836);
            results[r] = ((Model)this.ref()).intVar("val[" + r + "]", min, max);
            ((Model)this.ref()).element(results[r], matrix[r], colIndex, colOffset).post();
        }
        ((Model)this.ref()).element(value, results, rowIndex, rowOffset).post();
        return results;
    }

    default public IntVar[] regularDec(IntVar[] vars, IAutomaton automaton) {
        int n = vars.length;
        IntVar[] states = new IntVar[n + 1];
        TIntHashSet[] layer = new TIntHashSet[n + 1];
        for (int i = 0; i <= n; ++i) {
            layer[i] = new TIntHashSet();
        }
        layer[0].add(automaton.getInitialState());
        states[0] = ((Model)this.ref()).intVar("Q_" + ((Model)this.ref()).nextId(), layer[0].toArray());
        TIntHashSet nexts = new TIntHashSet();
        for (int i = 0; i < n; ++i) {
            int ub = vars[i].getUB();
            Tuples tuples = new Tuples(true);
            int j = vars[i].getLB();
            while (j <= ub) {
                TIntIterator layerIter = layer[i].iterator();
                while (layerIter.hasNext()) {
                    int k = layerIter.next();
                    nexts.clear();
                    automaton.delta(k, j, nexts);
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        int succ = it.next();
                        if (i + 1 >= n && !automaton.isFinal(succ)) continue;
                        layer[i + 1].add(succ);
                        tuples.add(k, succ, j);
                    }
                }
                j = vars[i].nextValue(j);
            }
            states[i + 1] = ((Model)this.ref()).intVar("Q_" + ((Model)this.ref()).nextId(), layer[i + 1].toArray());
            ((Model)this.ref()).table(new IntVar[]{states[i], states[i + 1], vars[i]}, tuples, "CT+").post();
        }
        return states;
    }

    default public void binPackingDec(IntVar[] bin, int[] w, IntVar[] load, int offset) {
        int i;
        ((Model)this.ref()).sum(load, "=", Arrays.stream(w).sum()).post();
        for (i = 0; i < bin.length; ++i) {
            ((Model)this.ref()).member(bin[i], offset, load.length - 1 + offset).post();
        }
        for (i = 0; i < load.length; ++i) {
            IntVar[] in = new BoolVar[bin.length];
            for (int j = 0; j < bin.length; ++j) {
                in[j] = ((Model)this.ref()).intEqView(bin[j], i + offset);
            }
            ((Model)this.ref()).scalar(in, w, "=", load[i]).post();
        }
    }

    default public void circuitDec(IntVar[] S, int offset) {
        int n = S.length;
        ((Model)this.ref()).allDifferent(S, "AC").post();
        IntVar[] t = ((Model)this.ref()).intVarArray("t", n - 1, 1 + offset, n - 1 + offset);
        ((Model)this.ref()).allDifferent(t, "AC3").post();
        ((Model)this.ref()).element(t[0], S, ((Model)this.ref()).intVar(offset), 0).post();
        for (int i = 1; i < n - 2; ++i) {
            ((Model)this.ref()).element(t[i], S, t[i - 1], 0).post();
        }
        ((Model)this.ref()).element(((Model)this.ref()).intVar(offset), S, t[n - 2], 0).post();
    }

    default public void argmaxDec(IntVar z, int offset, IntVar[] vars) {
        int n = vars.length;
        int min = Stream.of(vars).mapToInt(IntVar::getLB).min().getAsInt();
        int max = Stream.of(vars).mapToInt(IntVar::getUB).max().getAsInt();
        IntVar[] q = new IntVar[n];
        IntVar M = ((Model)this.ref()).intVar("M", n * min, n * (max + 1));
        z.ge(0).post();
        z.lt(vars.length).post();
        for (int j = 0; j < n; ++j) {
            q[j] = ((Model)this.ref()).intAffineView(n, vars[j], n - j);
            z.ne(j + offset).iff(M.gt(q[j])).post();
        }
        ((Model)this.ref()).max(M, q).post();
    }

    default public void argminDec(IntVar z, int offset, IntVar[] vars) {
        int n = vars.length;
        int min = Stream.of(vars).mapToInt(IntVar::getLB).min().getAsInt();
        int max = Stream.of(vars).mapToInt(IntVar::getUB).max().getAsInt();
        IntVar[] q = new IntVar[n];
        IntVar M = ((Model)this.ref()).intVar("M", n * min, n * (max + 1));
        for (int j = 0; j < n; ++j) {
            q[j] = ((Model)this.ref()).intAffineView(n, vars[j], j);
            z.ne(j + offset).iff(M.lt(q[j])).post();
        }
        ((Model)this.ref()).min(M, q).post();
    }

    default public void ifThenElseDec(BoolVar[] c, int[] x, IntVar y) {
        Tuples tuples = new Tuples();
        int star = Math.max(2, y.getUB() + 1);
        tuples.setUniversalValue(star);
        int[] t = new int[c.length + 1];
        Arrays.fill(t, 0);
        t[c.length] = star;
        tuples.add((int[])t.clone());
        Arrays.fill(t, star);
        for (int i = 0; i < c.length; ++i) {
            if (i > 0) {
                t[i - 1] = 0;
            }
            t[i] = 1;
            t[c.length] = x[i];
            tuples.add((int[])t.clone());
        }
        ((Model)this.ref()).table(ArrayUtils.append(new IntVar[][]{c, {y}}), tuples).post();
    }

    default public void ifThenElseDec(BoolVar[] c, IntVar[] x, IntVar y) {
        Tuples tuples = new Tuples();
        int univ = Math.max(2, y.getUB() + 1);
        tuples.setUniversalValue(univ);
        int[] t = new int[c.length + 1];
        Arrays.fill(t, 0);
        t[c.length] = c.length;
        tuples.add((int[])t.clone());
        Arrays.fill(t, univ);
        int i = 0;
        while (i < c.length) {
            if (i > 0) {
                t[i - 1] = 0;
            }
            t[i] = 1;
            t[c.length] = i++;
            tuples.add((int[])t.clone());
        }
        IntVar idx = ((Model)this.ref()).intVar(0, c.length);
        ((Model)this.ref()).table(ArrayUtils.append(new IntVar[][]{c, {idx}}), tuples).post();
        ((Model)this.ref()).element(y, ArrayUtils.append(x, {y}), idx, 0).post();
    }

    default public void product(IntVar[][] A, IntVar[][] B, IntVar[][] C) {
        if (!(1.$assertionsDisabled || A.length > 0 && B.length > 0 && C.length > 0)) {
            throw new AssertionError();
        }
        if (!(1.$assertionsDisabled || A[0].length > 0 && B[0].length > 0 && C[0].length > 0)) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A[0].length != B[0].length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A.length != C.length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && B[0].length != C[0].length) {
            throw new AssertionError();
        }
        int n = B.length;
        int m = C.length;
        int p = C[0].length;
        Model model = C[0][0].getModel();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < p; ++j) {
                int finalI = i;
                int finalJ = j;
                model.sum((IntVar[])IntStream.range(0, n).mapToObj(k -> A[finalI][k].mul((ArExpression)B[k][finalJ]).intVar()).toArray(IntVar[]::new), "=", C[i][j]).post();
            }
        }
    }

    default public void product(BoolVar[][] A, BoolVar[][] B, BoolVar[][] C) {
        if (!(1.$assertionsDisabled || A.length > 0 && B.length > 0 && C.length > 0)) {
            throw new AssertionError();
        }
        if (!(1.$assertionsDisabled || A[0].length > 0 && B[0].length > 0 && C[0].length > 0)) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A[0].length != B[0].length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && A.length != C.length) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && B[0].length != C[0].length) {
            throw new AssertionError();
        }
        int n = B.length;
        int m = C.length;
        int p = C[0].length;
        Model model = C[0][0].getModel();
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < p; ++j) {
                int finalI = i;
                int finalJ = j;
                model.addClausesBoolOrArrayEqVar((BoolVar[])IntStream.range(0, n).mapToObj(k -> A[finalI][k].and(B[k][finalJ]).boolVar()).toArray(BoolVar[]::new), C[i][j]);
            }
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

