% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_modified_data.R
\name{gen_modified_data}
\alias{gen_modified_data}
\title{Search for Newly Added Objects or Documented Changes to Objects in GENESIS}
\usage{
gen_modified_data(
  code = "",
  type = c("all", "tables", "statistics", "statisticsUpdates"),
  date = c("now", "week_before", "month_before", "year_before"),
  ...
)
}
\arguments{
\item{code}{a string with a maximum length of 15 characters. Code from a GENESIS object. Only one code per iteration. "*" notations are possible. Empty code (default value) includes all changes, updates, and new added objects.}

\item{type}{a string. Specific GENESIS object type: 'tables', 'statistics', and 'statisticsUpdates'. All three can be accessed through "all", which is the default.}

\item{date}{a string. Specific date that is used as the last update or upload time in GENESIS to include a GENESIS object in return. Default option is 'now', which uses the current date of your system. Alternative options are 'week_before', using the current date of your system minus 7 days, 'month_before', using the current date of your system minus 4 weeks, and 'year_before', using the current date of your system minus 52 weeks. Additionally, it is possible to fill in a specific date of format 'DD.MM.YYYY'.}

\item{...}{Additional parameter of the GENESIS API call. These parameters are only affecting the GENESIS API call itself, no further processing.}
}
\value{
A list with all recalled elements from GENESIS. Always includes the code of the object, the title, and the type of the object. This is done to facilitate further processing with the data. Attributes are added to the data.frame describing the search configuration for the returned output.
}
\description{
Function to check for updates, changes, or new objects in GENESIS based on a specific date.
}
\examples{
\dontrun{
# Find objects which were modified last_week
object <- gen_modified_data(date = "week_before")

# Find tables that were new from 31.03.2020
object <- gen_modified_data(type = "tables", date = "31.03.2020")

# Find objects related to the topic "Bevölkerung" (Code: '12*') which were new today
object <- gen_modified_data(code = "12*")
}

}
