% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_compressed_sdmx.R
\name{get_compressed_sdmx}
\alias{get_compressed_sdmx}
\title{Download and extract compressed SDMX XML}
\usage{
get_compressed_sdmx(url = NULL, verbose = FALSE)
}
\arguments{
\item{url}{a URL from the bulk download facility to download the zipped SDMX XML file}

\item{verbose}{a logical value with default \code{FALSE}, so detailed messages (for debugging) will not printed.
Can be set also with \code{options(restatapi_verbose=TRUE)}.}
}
\value{
an xml class object with SDMX tags extracted and read from the downloaded file.
}
\description{
Downloads  and extracts the data values from the SDMX XML data file
}
\details{
It is a sub-function to use in the \code{\link{get_eurostat_raw}} and the \code{\link{get_eurostat_data}} functions.
}
\examples{
base_url<-"https://ec.europa.eu/eurostat/"
url_end<-"estat-navtree-portlet-prod/BulkDownloadListing?file=data/agr_r_milkpr.sdmx.zip"
url<-paste0(base_url,url_end)
sdmx_xml<-get_compressed_sdmx(url,verbose=TRUE)

}
