% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_cfg.R
\name{load_cfg}
\alias{load_cfg}
\title{Load configuration data from JSON}
\usage{
load_cfg(api_version = "current", verbose = FALSE)
}
\arguments{
\item{api_version}{It can be either "old", "new", "test" or "current". The default value is "current".}

\item{verbose}{A boolean if the verbose message about the configuration to be showed or not. The default is \code{FALSE}.}
}
\value{
it returns 2 objects in the '.restatapi_env'  
\itemize{
 \item \code{cfg} a list with all the configuration data
 \item \code{rav} a character string with a number defining the API_VERSION from the config file to be used later. It is determined based on the \code{api_version} parameter.   
 }
}
\description{
Load the configuration information to the '.restatapi_env' from the JSON configuration file.
}
\details{
Loads configuration data from a JSON file. The function first tries to load the configuration file from GitHub. If it is not possible it loads from  By this way different version of the API can be tested.
}
\examples{
\donttest{
load_cfg()
load_cfg(api_version="test",verbose=TRUE)
}
\dontshow{
load_cfg()
}

}
