% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/co2_flush.R
\encoding{UTF-8}
\name{co2_flush}
\alias{co2_flush}
\title{Calculate CO2 to add to flush reservoir}
\usage{
co2_flush(goal_pco2, resp_pH, resp_vol, flush_pH, flush_vol, flush_remain = 0,
  temp = 25, sal = 35, TA = NULL, atm_pres = 1013.25)
}
\arguments{
\item{goal_pco2}{the desired pCO2 in the respirometer after the flush (uatm).}

\item{resp_pH}{pH inside the respirometer before the flush (total scale).}

\item{resp_vol}{volume of the respirometer (liter).}

\item{flush_pH}{pH of the reservoir water used for flushing before CO2 is added (total scale).}

\item{flush_vol}{volume of the flush reservoir (liter).}

\item{flush_remain}{volume of the flush reservoir that will remain after the flush (liter).}

\item{temp}{temperature (°C). Default is 25 °C.}

\item{sal}{salinity (psu). Default is 35 psu. If \code{sal} < 26 psu, then \code{TA} must be provided.}

\item{TA}{(optional) total alkalinity (umol / kg). If undefined TA is estimated from salinity using \code{\link{guess_TA}}.}

\item{atm_pres}{atmospheric pressure (mbar). Default is 1013.25 mbar.}
}
\value{
moles of CO2 gas to be added to the flush reservoir.
}
\description{
Calculates the moles of CO2 gas to be added to a seawater reservoir before flushing a respirometer to achieve the desired pCO2 in the respirometer after the flush. Useful for ocean acidification experiments where CO2 treatments are desired.
}
\note{
It is assummed that the entire reservoir is drained into the respirometer during the flush. It is also assumed that all of the CO2 added dissolves and remains in solution. This can be achieved (almost completely) by bubbling CO2 according to Jokiel et al. 2014.
}
\examples{
# I want the respirometer to have a pCO2 = 1000 uatm. It currently has a pH of 7.6 and is 90 L.
# If I have a 200 L reservoir with pH = 7.9 seawater, how much CO2 do I need
# to add to the flush reservoir?
co2_flush(goal_pco2 = 1000, resp_pH = 7.6, resp_vol = 90, flush_pH = 7.9, flush_vol = 200)

}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
\references{
Jokiel PL, Bahr KD, Rodgers KS. 2014. Low-cost, high-flow mesocosm system for simulating ocean acidification with CO2 gas. Limnol Oceanogr Methods. 12:313–322.
}
\seealso{
\code{\link{co2_add}}, \code{\link{co2_rate}}, \code{\link{flush_carb}}, \code{\link[seacarb]{carb}}, \code{\link{peri_pump}}
}

