% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fastTrapz}
\alias{fastTrapz}
\title{Fast implementation of pracma::trapz from the Armadillo C++ library}
\usage{
fastTrapz(x, Y, dim = 1L)
}
\arguments{
\item{x}{x-coordinates of points on the x-axis (vector)}

\item{Y}{y-coordinates of function values (matrix)}

\item{dim}{an integer giving the subscripts which the function will be applied over. 1 indicates rows, 2 indicates columns}
}
\value{
a vector with one dimension less than Y
}
\description{
Compute the area of a multivariate function with (matrix) values Y at the points x.
}
\examples{
x = 1:10
Y = sin(pi/10*matrix(1:10,ncol=10,nrow=10))
fastTrapz(x*pi/10,Y,2)
}
