% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_stratified.R
\name{sample_stratified}
\alias{sample_stratified}
\title{A function to create calibration and validation sample sets for
leave-group-out cross-validation}
\usage{
sample_stratified(y, p, number, group = NULL, replacement = FALSE, seed = NULL)
}
\arguments{
\item{y}{a matrix of one column with the response variable.}

\item{p}{the percentage of samples (or groups if group argument is used) to
retain in the validation_indices set}

\item{number}{the number of sample groups to be crated}

\item{group}{the labels for each sample in \code{y} indicating the group each
observation belongs to.}

\item{replacement}{A logical indicating sample replacements for the
calibration set are required.}

\item{seed}{an integer for random number generator (default \code{NULL}).}
}
\value{
a list with two matrices (\code{hold_in} and
\code{hold_out}) giving the indices of the observations in each
column. The number of columns represents the number of sampling repetitions.
}
\description{
for internal use only! This is stratified sampling based on the
values of a continuous response variable (y). If group is provided, the
sampling is done based on the groups and the average of y per group. This
function is used to create calibration and validation groups for
leave-group-out cross-validations (or
leave-group-of-groups-out cross-validation if group argument is provided).
}
\keyword{internal}
