% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproj-external-types.R, R/reproj.R
\name{reproj.sc}
\alias{reproj.sc}
\alias{reproj.mesh3d}
\alias{reproj.quadmesh}
\alias{reproj.triangmesh}
\alias{reproj}
\alias{reproj.matrix}
\alias{reproj.data.frame}
\title{Reproject coordinates.}
\usage{
\method{reproj}{sc}(x, target = NULL, ..., source = NULL)

\method{reproj}{mesh3d}(x, target, ..., source = NULL)

\method{reproj}{quadmesh}(x, target, ..., source = NULL)

\method{reproj}{triangmesh}(x, target, ..., source = NULL)

reproj(x, target, ..., source = NULL, four = FALSE)

\method{reproj}{matrix}(x, target, ..., source = NULL, four = FALSE)

\method{reproj}{data.frame}(x, target, ..., source = NULL, four = FALSE)
}
\arguments{
\item{x}{coordinates}

\item{target}{target specification (PROJ.4 string or epsg code)}

\item{...}{arguments passed to \code{\link[proj4:ptransform]{proj4::ptransform()}}}

\item{source}{source specification (PROJ.4 string or epsg code)}

\item{four}{if \code{TRUE}, and PROJ version 6 is available return four columns xyzt (not just three xyz)}
}
\value{
matrix
}
\description{
Reproject coordinates from a matrix or data frame by explicitly specifying the
'source' and 'target' projections.
}
\details{
If the modern version of the library 'proj' is available, \code{reproj()} uses
the PROJ package, otherwise it falls pack to the proj4 package.

If using proj4, reproj drives the function \code{\link[proj4:ptransform]{proj4::ptransform()}} and sorts out
the requirements for it so that we can simply give coordinates in data frame
or matrix form, with a source projection and a target projection.

If using PROJ, reproj can pass in a wider variety of source and target
strings, not just "proj4string" and we are completely subject to the new
rules and behaviours of the PROJ library. We always assume "visualization
order", i.e. longitude then latitude, easting then northing (as X, Y).

The basic function \code{reproj()} takes input in generic form (matrix or data
frame) and returns a 3-column matrix (or 4-column if \code{four = TRUE}), by
transforming from map projection specified by the  \code{source} argument to that
specified by the \code{target} argument.  Only column order is respected, column
names are ignored.

This model of working also allows adding methods for specific data formats
that already carry a suitable \code{source} projection string. Currently we
support types from the silicate and quadmesh and rgl packages, and only the
\code{target} string need be specified.

This model has obvious flexibility, for packages to import the generic and
call it with the correct \code{source} (from the data format) and the \code{target}
from user, or process controlled mechanism.

The \code{source} argument must be named, and if it is not present a light check
is made that the source data could be "longitude/latitude" and transformation
to \code{target} is applied (this can be controlled by setting options).

The function\code{reproj()} always returns a 3-column matrix \emph{unless} \code{four = TRUE}, and \code{\link[PROJ:ok_proj6]{PROJ::ok_proj6()}} is \code{TRUE} and then a 4-column matrix is returned.

Note that any integer input for \code{source} or \code{target} will be formatted to a
character string like "EPSG:<integer_code>" ('PROJ' package in use) or
"+init=epsg:<integer_code>" ('proj4' package in use), depending on the
outcome of \code{PROJ::ok_proj6()}. This test function can be configured to
alternatively use 'proj4' for expert use.

Until recently the \code{proj4} package was the only one available for generic
data that will transform between arbitrary coordinate systems specified by
\emph{source} and \emph{target} coordinate systems and with control over 'xy' versus
'xyz' input and output.  This package adds some further features by wrapping
the need to convert longitude/latitude data to or from radians.

Other R packages for transforming coordinates are geared toward data
that's in a particular format. It's true that only GDAL provides the full
gamut of available geographic map projections, but this leaves a huge variety
of workflows and applications that don't need that level of functionality.
}
\section{Dependencies}{

\itemize{
\item The \href{https://CRAN.r-project.org/package=PROJ}{PROJ} package is used
preferentially if is functional, using the underlying 'PROJ-lib' at version 6
or higher. * The \href{https://CRAN.r-project.org/package=proj4}{proj4} package is
used if PROJ is not functional.
The proj4 package works perfectly well with the PROJ-lib at versions 4, 5, 6,
or 7 and if this is preferred reproj can be set to ignore the PROJ R package
(see
\href{https://hypertidy.github.io/reproj/reference/reproj-package.html}{reproj-package}).
}
}

\section{Global options}{

\subsection{Assuming longitude/latitude input}{

The behaviour is controlled by user-settable options which on start up are
\code{reproj.assume.longlat = TRUE} and
\code{reproj.default.longlat = "+proj=longlat +datum=WGS84 +no_defs"}.

If the option \code{reproj.assume.longlat} is set to FALSE then the \code{source}
argument must be named explicitly, i.e. \code{reproj(xy, t_srs, source = s_srs)},
this is to help catch mistakes being made. The \code{target} is the second
argument in \code{reproj} though it is the third argument in \code{proj4::ptransform}.
This function also converts to radians on input or output as required.

If the option \code{reproj.assume.longlat} is set to TRUE and the input data
appear to be sensible longitude/latitude values, then the value of
\code{reproj.default.longlat} is used as the assumed source projection.
}

\subsection{Controlling use or PROJ or proj4}{

See \link{reproj-package} for another option set \code{reproj.mock.noproj6} for package
testing for expert use.
}
}

\section{Warning}{


There are a number of limitations to the PROJ library please use at your own
risk. The sf package provides a better supported facility to modern code and
especially for datum transformations.
}

\examples{
reproj(cbind(147, -42), target = "+proj=laea +datum=WGS84",
                         source = "+proj=longlat +datum=WGS84")
}
