% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectSize.R
\name{objSize}
\alias{objSize}
\alias{objSizeSession}
\title{Wrapper around \code{lobstr::obj_size}}
\usage{
objSize(x, quick = TRUE, ...)

objSizeSession(sumLevel = Inf, enclosingEnvs = TRUE, .prevEnvirs = list())
}
\arguments{
\item{x}{An object}

\item{quick}{Logical. If \code{FALSE}, then an attribute, "objSize" will be added to
the returned value, with each of the elements' object size returned also.}

\item{...}{Additional arguments (currently unused), enables backwards compatible use.}

\item{sumLevel}{Numeric, indicating at which depth in the list of objects should the
object sizes be summed (summarized). Default is \code{Inf}, meaning no sums. Currently,
the only option other than Inf is 1: \code{objSizeSession(1)},
which gives the size of each package.}

\item{enclosingEnvs}{Logical indicating whether to include enclosing environments.
Default \code{TRUE}.}

\item{.prevEnvirs}{For internal account keeping to identify and prevent duplicate counting}
}
\description{
This will return the result from \code{lobstr::obj_size}, i.e., a \code{lobstr_bytes}
which is a \code{numeric}. If \code{quick = FALSE}, it will also have an attribute,
"objSize", which will
be a list with each element being the \code{objSize} of the individual elements of \code{x}.
This is particularly useful if \code{x} is a \code{list} or \code{environment}.
However, because of the potential for shared memory, the sum of the individual
elements will generally not equal the value returned from this function.
}
\details{
For functions, a user can include the enclosing environment as described
\url{https://www.r-bloggers.com/2015/03/using-closures-as-objects-in-r/} and
\url{http://adv-r.had.co.nz/memory.html}.
It is not entirely clear which estimate is better.
However, if the enclosing environment is the \code{.GlobalEnv}, it will
not be included even though \code{enclosingEnvs = TRUE}.

\code{objSizeSession} will give the size of the whole session, including loaded packages.
Because of the difficulties in calculating the object size of \code{base}
and \code{methods} packages and \code{Autoloads}, these are omitted.
}
\examples{
library(utils)

foo <- new.env()
foo$b <- 1:10
foo$d <- 1:10

objSize(foo) # all the elements in the environment
object.size(foo) # different - only measuring the environment as an object

object.size(prepInputs) # only the function, without its enclosing environment
objSize(prepInputs)     # the function, plus its enclosing environment

# Size of all packages; includes their imported functions
\dontrun{
  bar <- objSizeSession(1)
  print(bar, units = "auto")
}

os1 <- object.size(as.environment("package:reproducible"))
os2 <- objSize(as.environment("package:reproducible"))
(os1) # very small -- just the environment container
sum(unlist(os2)) # around 13 MB, with all functions, objects
                 # and imported functions

}
