% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Madeyski10}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Madeyski10}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Madeyski10 data}
\format{
`KitchenhamEtAl.CorrelationsAmongParticipants.Madeyski10`: a data frame with 45 rows
and 10 variables:
\describe{
\item{ExperimentID}{<fct>| ExperimentID: This experiment is the only cross-over experiment in
the family of TDD and Pair-Programming experiments conducted by Madeyski, so all values in this
column are set to 'P2007'.}
\item{ParticipantID}{<fct> | Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct> | Experimental Sequence Group: A (TLSP-TFSP), B (TFSP-TLSP)}
\item{System}{<fct> | Software system to develop: Smell (a tool for identifying bad code smells
in Java source code through the use of a set of software metrics) or Library (a library
application)}
\item{Period}{<fct> | Time period of the cross-over experiment: 1 or 2}
\item{Treatment}{<fct> | Experimental Treatment: Test-First Solo Programming (TFSP) vs Test-Last
Solo Programming (TLSP)}
\item{PATP}{<dbl> | Dependent variable: Percentage of Acceptance Tests Passed}
\item{NATPPH}{<dbl> | Dependent variable: Number of Acceptance Tests Passed Per Hour}
\item{CBO}{<dbl> | Dependent variable: Mean value of Coupling Between Objects (CBO), see CK set
of metrics}
\item{WMC}{<dbl> | Dependent variable: Mean value of Weighted Number of Methods in Class (WMC),
see CK set of metrics}
\item{RFC}{<dbl> | Dependent variable: Mean value of Response For a Class (RFC), see CK set of
metrics}
\item{CrossOverID}{<fct> | Cross-Over Code. This experiment is a simple two-group cross-over
experiment with one cross-over code, so all values in this column are set to 'CO1'.
However, four-group experiments require a code to identify the linked sequence groups
(although that can be deduced from the system used in the first time period).
A crossover code is also essential for non-parametric analysis.}
}
}
\source{
\url{https://madeyski.e-informatyka.pl/reproducible-research/}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Madeyski10
}
\description{
Data illustrate correlations between results from individual participants in cross-over
experiment P2007 (Smell and Library) conducted by Madeyski, see:
[1] Lech Madeyski, Test-Driven Development: An Empirical Evaluation of Agile Practice.
(Heidelberg, London, New York): Springer, 2010. Foreword by Prof. Claes Wohlin.
If you use this data set please cite:
[1] Lech Madeyski, Test-Driven Development: An Empirical Evaluation of Agile Practice.
(Heidelberg, London, New York): Springer, 2010. Foreword by Prof. Claes Wohlin.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, 'The importance
of the Correlation between Results from Individual Participants in Crossover Experiments'
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Madeyski10

}
\keyword{datasets}
