% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{Cliffd}
\alias{Cliffd}
\title{Cliffd}
\usage{
Cliffd(x, y, alpha = 0.05, sigfig = -1)
}
\arguments{
\item{x}{is a vector of values from group 1}

\item{y}{is a vector of values from group 2}

\item{alpha}{is the Type 1 error level for statistical tests}

\item{sigfig}{is the number of significant digit. If sigfig>0 the data in x and y is truncated to the specified value.}
}
\value{
list including the value of Cliffs d its consistent variance and confidence intervals and the equivalent probability of superiority value and its confidence intervals.
x=c(1.2,3,2.2,4,2.5,3)
y=c(3,4.2,4,6,7,5.9)
# Cliffd(x,y)
#  $n1
# [1] 6
# $n2
# [1] 6
# $cl
# [1] -0.9772519
# $cu
# [1] -0.3476461
# $d
# [1] -0.8611111
# $sqse.d
# [1] 0.02017931
# $phat
# [1] 0.06944444
# $summary.dvals
#        P(X<Y)     P(X=Y)     P(X>Y)
# [1,] 0.8888889 0.08333333 0.02777778
# $p.cl
# [1] 0.01137405
# $p.cu
# [1] 0.326177
#
z=c(1,2,3,4)
y=c(5,6,7,8)
Cliffd(z,y)
# $n1
# [1] 4
# $n2
# [1] 4
# $cl
# [1] -1
# $cu
# [1] -0.4368172
# $d
# [1] -1
# $sqse.d
# [1] 0.009765625
# $phat
# [1] 0
# $summary.dvals
#      P(X<Y) P(X=Y) P(X>Y)
# [1,]      1      0      0
# $p.cl
# [1] 0
# $p.cu
# [1] 0.2815914
}
\description{
This function implements finds Cliff's d and its confidence intervals. The null hypothesis is that for two independent group, P(X<Y)=P(X>Y). The function reports a 1-alpha confidence interval for P(X>Y)-P(X<Y). The algorithm computes a confidence interval for Cliff's d using the method in Cliff, 1996, p. 140, eq 5.12. The function is based on code produce by Rand Wilcox but has been amended. The plotting function has been removed and the dependency on Wilcox's binomci function has been removed. Construction of confidence intervals if values in one group are all larger than values in the other group has been amended to use the smallest non-zero variance method. Upper and lower confidence interval bounds cannot assume invalid values, i.e. values <-1 or >1.
}
\author{
Rand Wilcox, amendments Barbara Kitchenham and Lech Madeyski
}
