% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_untag}
\alias{repo_untag}
\title{Remove tags from an item.}
\usage{
repo_untag(rp, name = NULL, rmtags, tags = NULL)
}
\arguments{
\item{rp}{An object of class repo.}

\item{name}{An item name.}

\item{rmtags}{A list of tags that will be removed from the item's
tag list.}

\item{tags}{A list of tags: rmtags will be removed from all items
matching the list.}
}
\value{
Used for side effects.
}
\description{
Remove tags from an item.
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", c("tag1", "tag2"))
rp$print(show="t")
rp$untag("item1", "tag2")
rp$print(show="t")

## wiping temporary repo
unlink(rp_path, TRUE)
}
\seealso{
repo_tag, repo_set
}

