% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{print.repo}
\alias{print.repo}
\title{Show a summary of the repository contents.}
\usage{
\method{print}{repo}(x, tags = NULL, all = F, show = "ds", ...)
}
\arguments{
\item{x}{An object of class repo.}

\item{tags}{A list of character tags. Only items matching all the
tags will be shown.}

\item{all}{Show also items tagged with "hide".}

\item{show}{Select columns to show.}

\item{...}{Further arguments passed to or from other methods}
}
\value{
Used for side effects.
}
\description{
Show a summary of the repository contents.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(1, "item1", "Sample item 1", c("tag1", "tag2"), replace=TRUE)
repo$put(2, "item2", "Sample item 2", c("tag1", "hide"), replace=TRUE)
repo$put(3, "item3", "Sample item 3", c("tag2", "tag3"), replace=TRUE)
repo$print()
repo$print(all=TRUE)
repo$print(show="tds", all=TRUE)
repo$print(show="tds", all=TRUE, tags="tag1")
## wiping the temp repo
unlink(repo_path, TRUE)

## wiping temporary repo
unlink(repo_path, TRUE)
}

