% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renameRestrictCols.R
\name{replyr_mapRestrictCols}
\alias{replyr_mapRestrictCols}
\title{Map names of columns to known values and drop other columns.}
\usage{
replyr_mapRestrictCols(x, nmap, ..., restrict = FALSE, reverse = FALSE)
}
\arguments{
\item{x}{data item to work on}

\item{nmap}{named list mapping with keys specifying new column names, and values as original column names.}

\item{...}{force later arguments to bind by name}

\item{restrict}{logical if TRUE restrict to columns mentioned in nmap.}

\item{reverse}{logical if TRUE apply the inverse of nmap instead of nmap.}
}
\value{
data item with columns renamed (and possibly restricted).
}
\description{
Restrict a data item's column names and re-name them in bulk.
}
\details{
Something like \code{replyr::replyr_mapRestrictCols} is only useful to get control of a function that is not parameterized
(in the sense it has hard-coded column names inside its implementation that don't the match column names in our data).
}
\examples{

# an external function with hard-coded column names
DecreaseRankColumnByOne <- function(d) {
  d$RankColumn <- d$RankColumn - 1
  d
}

# our example data, with different column names
d <- data.frame(Sepal_Length=c(5.8,5.7),
                Sepal_Width=c(4.0,4.4),
                Species='setosa',rank=c(1,2))
print(d)


# map our data to expected column names so we can use function
nmap <- c(GroupColumn='Species',
          ValueColumn='Sepal_Length',
          RankColumn='rank')
print(nmap)
dm <- replyr_mapRestrictCols(d,nmap)
print(dm)

# can now apply code that expects hard-coded names.
dm <- DecreaseRankColumnByOne(dm)

# map back to our original column names (for the columns we retained)
# Note: can only map back columns that were retained in first mapping.
replyr_mapRestrictCols(dm, nmap, reverse=TRUE)

}
\seealso{
\code{\link{let}}, \code{\link{replyr_reverseMap}}, \code{\link{replyr_apply_f_mapped}}
}
