% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/obkData.R
\name{as.ejObject.obkData}
\alias{as.ejObject.obkData}
\title{This function processes objects from the obkClass data and
converts to the epiJSON format}
\usage{
\method{as.ejObject}{obkData}(x, metadata = list(), ...)
}
\arguments{
\item{x}{An record from the obkData}

\item{metadata}{The list of the components in the metadata}

\item{...}{other parameters (to maintain consistency with the generic)}
}
\value{
an ejObject
}
\description{
This function processes objects from the obkClass data and
converts to the epiJSON format
}
\note{
There is a slight mismatch in symantics here obkData individuals are
 equivelent to EpiJSON records and obkData records are EpiJSON events. This
 is beause in EpiJSON the unit of record is not necessarily an individual
 (it could, for example, be a region or hospital, etc).
}
\examples{
require('OutbreakTools')
data(ToyOutbreak)
x=subset(ToyOutbreak,2)
as.ejObject(x, metadata=list())
}

