% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{record}
\alias{record}
\title{Update Package Records in a Lockfile}
\usage{
record(records, lockfile = file.path(project, "renv.lock"), project = NULL)
}
\arguments{
\item{records}{A list of named records, mapping package names to a definition
of their source. See \strong{Records} for more details.}

\item{lockfile}{The path to a lockfile. By default, the project lockfile
is used.}

\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\description{
Use \code{record()} to record a new entry within an existing \code{renv} lockfile.
}
\details{
This function can be useful when you need to change one or more of the
package records within an \code{renv} lockfile -- for example, because a recorded
package cannot be restored in a particular environment, and you know of a
suitable alternative.
}
\section{Records}{


Records can be provided either using the \strong{remotes} short-hand syntax,
or by using an \R list of entries to record within the lockfile. See
\code{?lockfiles} for more information on the structure of a package record.
}

\examples{

\dontrun{

# use digest 0.6.22 from package repositories -- different ways
# of specifying the remote. use whichever is most natural
renv::record("digest@0.6.22")
renv::record(list(digest = "0.6.22"))
renv::record(list(digest = "digest@0.6.22"))

# alternatively, provide a full record as a list
digest_record <- list(
  Package = "digest",
  Version = "0.6.22",
  Source  = "Repository",
  Repository = "CRAN"
)

renv::record(list(digest = digest_record))

}
}
