% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/entrez_info.r
\name{entrez_db_searchable}
\alias{entrez_db_searchable}
\title{Can be used in conjunction with \code{\link{entrez_search}} to find available
search fields to include in the \code{term} argument of that function.}
\usage{
entrez_db_searchable(db, config = NULL)
}
\arguments{
\item{db}{character, name of database to get search field from}

\item{config}{config vector passed to \code{httr::GET}}
}
\value{
An eInfoSearch object (subclassed from list) summarising linked-datbases.
Can be coerced to a data-frame with \code{as.data.frame}. Printing the object
shows only the names of each available search field.
}
\description{
Can be used in conjunction with \code{\link{entrez_search}} to find available
search fields to include in the \code{term} argument of that function.
}
\examples{
\donttest{
(pmc_fields <- entrez_db_searchable("pmc"))
pmc_fields[["AFFL"]]
entrez_search(db="pmc", term="Otago[AFFL]", retmax=0)
entrez_search(db="pmc", term="Auckland[AFFL]", retmax=0)

sra_fields <- entrez_db_searchable("sra")
as.data.frame(sra_fields)
}
}
\seealso{
\code{\link{entrez_search}}

Other einfo: \code{\link{entrez_db_links}};
  \code{\link{entrez_db_summary}};
  \code{\link{entrez_dbs}}; \code{\link{entrez_info}}
}

