% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.r
\name{client}
\alias{client}
\title{Client Launcher}
\usage{
client(addr = "localhost", port = 55555, prompt = "remoteR")
}
\arguments{
\item{addr}{The remote host/address/endpoint.}

\item{port}{The port (number) that will be used for communication between 
the client and server.  The port value for the client and server
must agree.}

\item{prompt}{The prompt to use to delineate the client from the normal R REPL.}
}
\value{
Returns \code{TRUE} invisibly on successful exit.
}
\description{
Connect to a remote server (launch the client).
}
\details{
The \code{port} values between the client and server must agree.
If they do not, this can cause the client to hang.

The client is a specialized REPL that intercepts commands sent
through the R interpreter.  These commands are then sent from the
client to and evaluated on the server.
The client communicates over ZeroMQ with the server using a REQ/REP pattern.
Both commands (from client to server) and returns (from server
to client) are handled in this way.

To shut down the server and the client, see \code{exit()}.
}

