% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_extract.R
\name{c.reliabilitydiag}
\alias{c.reliabilitydiag}
\title{Combining reliability diagram objects}
\usage{
\method{c}{reliabilitydiag}(
  ...,
  tol = sqrt(.Machine$double.eps),
  xtype = NULL,
  xvalues = NULL,
  region.level = 0.9,
  region.method = NULL,
  region.position = "diagonal",
  n.boot = 100
)
}
\arguments{
\item{...}{objects to be concatenated.}

\item{tol}{accuracy when comparing \code{y} in \code{'reliabilitydiag'}
objects.}

\item{xtype}{a string specifying whether the prediction values should be
treated as \code{"continuous"} or \code{"discrete"}.}

\item{xvalues}{a numeric vector of possible prediction values;
values in \code{x} are rounded to the nearest value in \code{xvalues} and
\code{xtype} is set to \code{"discrete"}.}

\item{region.level}{a value in (0, 1) specifying the level at which
consistency or confidence regions are calculated.}

\item{region.method}{a string specifying whether \code{"resampling"},
\code{"continuous_asymptotics"}, or \code{"discrete_asymptotics"} are used
to calculate consistency/confidence regions.}

\item{region.position}{a string specifying whether consistency regions
around the \code{"diagonal"} or confidence regions around the
\code{"estimate"} are calculated.}

\item{n.boot}{the number of bootstrap samples when
\code{region.method == "resampling"}.}
}
\value{
an object inheriting from the class \code{'reliabilitydiag'}.
}
\description{
Combine two or more \code{'reliabilitydiag'} objects that are based on the
same observations. Other objects are coerced by \code{\link{as.reliabilitydiag}}
before combination.
}
\examples{
data("precip_Niamey_2016", package = "reliabilitydiag")

X <- precip_Niamey_2016[c("EMOS", "ENS")]
Y <- precip_Niamey_2016$obs
r0 <- reliabilitydiag0(Y)
r1 <- c(r0, X, EPC = precip_Niamey_2016$EPC, region.level = NA)
r1
c(r1, reliabilitydiag(Logistic = precip_Niamey_2016$Logistic, y = Y))

}
\seealso{
\code{\link{as.reliabilitydiag}}, \code{\link{[.reliabilitydiag}}.
}
