% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ehhs.R
\name{plot.ehhs}
\alias{plot.ehhs}
\title{Plot EHHS around a focal marker}
\usage{
\method{plot}{ehhs}(
  x,
  nehhs = FALSE,
  ylim = c(0, 1),
  type = "l",
  main = paste0("EHHS around '", x$mrk.name, "'"),
  xlab = "Position",
  ylab = "Extended Haplotype Homozygosity per Site",
  bty = "n",
  mrk.col = "gray",
  ...
)
}
\arguments{
\item{x}{data (output of \code{\link{calc_ehhs}}).}

\item{nehhs}{logical. If \code{TRUE}, plot normalized EHHS.}

\item{ylim}{the y limits of the plot}

\item{type}{plot type (see code{\link[graphics]{plot.default}}.
Type \code{"s"} or \code{"S"} yield both (the same) piecewise constant curve.}

\item{main}{title for the plot (default \code{NA}, i.e. none).}

\item{xlab}{title for the x-axis.}

\item{ylab}{title for the y-axis.}

\item{bty}{box type around plot (see \code{\link[graphics]{par}}).}

\item{mrk.col}{color of the vertical line at the focal marker position.}

\item{...}{further arguments to be passed to function \code{\link[graphics]{plot.default}}.}
}
\description{
Plot curve of EHHS values around a focal marker.
}
\examples{
#example haplohh object (280 haplotypes, 1424 SNPs)
#see ?haplohh_cgu_bta12 for details
data(haplohh_cgu_bta12)
#computing EHHS statisitics for the marker "F1205400"
#which displays a strong signal of selection
ehhs <- calc_ehhs(haplohh_cgu_bta12, mrk = "F1205400")
plot(ehhs)
}
\seealso{
\code{\link{data2haplohh}}, \code{\link{plot.ehh}}, \code{\link{calc_ehhs}}, \code{\link{scan_hh}}.
}
