% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractMatrices.R
\name{extractMatrices}
\alias{extractMatrices}
\title{This function extracts RAM matrices from a lavaan object.}
\usage{
extractMatrices(model)
}
\arguments{
\item{model}{Lavaan model object.}
}
\value{
The RAM matrices from \code{model}.
}
\description{
This function extracts RAM matrices from a lavaan object.
}
\examples{

library(lavaan)
data(HolzingerSwineford1939)
HS.model <- ' visual =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed =~ x7 + x8 + x9 '
mod <- cfa(HS.model, data=HolzingerSwineford1939)
mats = extractMatrices(mod)
}
\keyword{extract}

