% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{predictor}
\alias{predictor}
\title{Specify the distribution of a predictor variable}
\usage{
predictor(dist, ...)
}
\arguments{
\item{dist}{Name (as character vector) of the function to generate draws from
this predictor's distribution.}

\item{...}{Additional arguments to pass to \code{dist} when generating draws.}
}
\value{
A \code{predictor_dist} object, to be used in \code{population()} to specify a
population distribution
}
\description{
Predictor variables can have any marginal distribution as long as a function
is provided to sample from the distribution. Multivariate distributions are
also supported: if the random generation function returns multiple columns,
multiple random variables will be created, successively numbered.
}
\details{
The random generation function must take an argument named \code{n} specifying the
number of draws. For univariate distributions, it should return a vector of
length \code{n}; for multivariate distributions, it should return an array or
matrix with \code{n} rows and a column per variable.

Multivariate predictors are successively numbered. For instance, if predictor
\code{X} is specified with

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(mvtnorm)
predictor(dist = "rmvnorm", mean = c(0, 1),
          sigma = matrix(c(1, 0.5, 0.5, 1), nrow = 2))
}\if{html}{\out{</div>}}

then the population predictors will be named \code{X1} and \code{X2}, and will have
covariance 0.5.
}
\examples{
# Univariate normal distribution
predictor(dist = "rnorm", mean = 10, sd = 2.5)

# Multivariate normal distribution
library(mvtnorm)
predictor(dist = "rmvnorm", mean = c(0, 1, 7))
}
