% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piecewise_parametric_hinv.R
\name{h_inv_parametric}
\alias{h_inv_parametric}
\title{One parameter parametric warping on (0, T)}
\usage{
h_inv_parametric(grid, t_max = 1, beta = 0.01)
}
\arguments{
\item{grid}{grid of values over which to evaluate the function.}

\item{t_max}{maximum value to be evaluated on the time domain.}

\item{beta}{parameter that controls shape of warping. Result 
approaches identity warp as beta approaches zero.}
}
\value{
A numeric vector containing values for a single warping function.
}
\description{
One parameter parametric warping on (0, T)
}
\examples{
x = runif(100)
plot(x, type = 'l')
lines(registr:::h_inv_parametric(grid = x, beta = 0.5), col = "red")
}
