% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_slopes.R
\name{simple_slopes}
\alias{simple_slopes}
\title{Simple slopes of interaction.}
\usage{
simple_slopes(model, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm', 'glm', 'aov', 'lme' (nlme),
or 'merMod' (lme4).}

\item{...}{Additional arguments to be passed to the particular method for the
given model.}
}
\value{
The form of the value returned by \code{simple_slopes} depends on the
  class of its argument. See the documentation of the particular methods for
  details of what is produced by that method.
}
\description{
\code{simple_slopes} is a generic function for calculating the simple effects
of an interaction in a regression model.
}
\examples{
# mtcars data
mtcars$am <- factor(mtcars$am)  # make 'am' categorical
model <- lm(mpg ~ wt * am, data=mtcars)
summary(model)  # significant interaction
simple_slopes(model)
simple_slopes(model,
    levels=list(wt=c(2, 3, 4, 'sstest'), am=c(0, 1, 'sstest')))  # test at specific levels
}
\seealso{
\code{\link{simple_slopes.lm}}, \code{\link{simple_slopes.glm}},
  \code{\link{simple_slopes.aov}}, \code{\link{simple_slopes.lme}},
  \code{\link{simple_slopes.merMod}}
}

