% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell_means.R
\name{cell_means_q.lm}
\alias{cell_means_q.lm}
\title{Estimated values of a linear model.}
\usage{
cell_means_q.lm(model, vars = NULL, levels = NULL)
}
\arguments{
\item{model}{A fitted linear model of type 'lm'.}

\item{vars}{A vector or list with variable names to be added to the table.}

\item{levels}{A list with element names corresponding to some or all of the
variables in the model. Each list element should be a vector with the names
of factor levels (for categorical variables) or numeric points (for
continuous variables) at which to test that variable.}
}
\value{
A data frame with a row for each predicted value. The first few
  columns identify the level at which each variable in your model was set.
  After columns for each variable, the data frame has columns for the
  predicted value, the standard error of the predicted mean, and the 95%
  confidence interval.
}
\description{
\code{cell_means_q.lm} calculates the predicted values at specific points,
given a fitted regression model.
}
\details{
By default, this function will provide means at -1SD, the mean, and +1SD for
continuous variables, and at each levele of categorical variables. This can
be overridden with the \code{levels} parameter.

If there are additional covariates in the model other than what are selected
in the function call, these variables will be set to their respective means.
In the case of a categorical covariate, the results will be averaged across
all its levels.

Note that in most cases it is easier to use \code{\link{cell_means.lm}} and
pass variable names in directly instead of strings of variable names.
\code{cell_means_q.lm} uses standard evaluation in cases where such
evaluation is easier.
}
\examples{
# iris data
model <- lm(Sepal.Length ~ Petal.Length + Petal.Width, iris)
summary(model)
cell_means_q.lm(model, 'Petal.Length')
}
\seealso{
\code{\link{cell_means.lm}}
}

