% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{rfg_location}
\alias{rfg_location}
\title{Bathroom locations}
\usage{
rfg_location(lat, lng, accessible = FALSE, unisex = FALSE,
  verbose = TRUE, tidy = FALSE)
}
\arguments{
\item{lat}{Location latitude}

\item{lng}{Location longitude}

\item{accessible}{If \code{TRUE}, only returns restrooms that meet the
Americans with Disability Act standards for accessibility.
Defaults to \code{FALSE}.}

\item{unisex}{If \code{TRUE}, only returns unisex restrooms.
Defaults to \code{FALSE}.}

\item{verbose}{If \code{TRUE}, prints query progress.
Defaults to \code{TRUE}.}

\item{tidy}{If \code{TRUE}, makes USA state names more consistent. The internal
function focuses on correcting known errors and mistakes, if incorrect state
data is supplied that cannot be corrected. Defaults to \code{FALSE}.}
}
\value{
A tibble with details of any and all nearby refuge bathrooms.
}
\description{
Given a pair of coordinates (latitude and longitude), finds any nearby
bathrooms, subject to other parameters.
}
\examples{
\donttest{

c <- rfg_location(lat=39, lng=-75)

}
}
