% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partisan.R
\name{part_decl_simple}
\alias{part_decl_simple}
\title{Calculate Simplified Declination}
\usage{
part_decl_simple(plans, shp, dvote, rvote)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{dvote}{unqouted name of column in shp with total population}

\item{rvote}{unqouted name of column in shp with group population}
}
\value{
numeric vector
}
\description{
Calculate Simplified Declination
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
part_decl_simple(plans = nh$r_2020, shp = nh, rvote = nrv, dvote = ndv)

# Or many plans:
part_decl_simple(plans = nh_m[, 3:5], shp = nh, rvote = nrv, dvote = ndv)

}
\references{
Jonathan N. Katz, Gary King, and Elizabeth Rosenblatt. 2020.
Theoretical Foundations and Empirical Evaluations of Partisan Fairness in District-Based Democracies.
American Political Science Review, 114, 1, Pp. 164-178.
}
\concept{partisan}
