% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recur.R
\name{Recur}
\alias{Recur}
\title{Formula Response for Recurrent Event Data}
\usage{
Recur(
  time,
  id,
  event,
  terminal,
  origin,
  check = c("hard", "soft", "none"),
  ...
)
}
\arguments{
\item{time}{A numerical vector representing the time of reccurence event or
censoring, or a list with elements named \code{"time1"} and
\code{"time2"} for specifying the follow-up of recurrent events.  In the
latter case, function \code{\%to\%} (or \code{\%2\%}) can be used for
ease of typing.  In addition to numeric values, \code{Date} and
\code{difftime} are allowed and converted to numeric values.  An error
will be thrown if this argument is not specified.}

\item{id}{Subject identificators. It can be numeric vector, character
vector, or a factor vector.  If it is left unspecified, \code{Recur}
will assume that each row represents a subject.}

\item{event}{A numeric vector that may represent the status, costs, or types
of the recurrent events. Logical vector is allowed and converted to
numeric vector. Non-positive values are internally converted to zero
indicating censoring status.}

\item{terminal}{A numeric vector that may represent the status, costs, or
types of the terminal events.  Logival vector is allowed and converted
to numeric vector.  Non-positive values are internally converted to zero
indicating censoring status.  If a scalar value is specified, all
subjects will have the same status of terminal events at their last
recurrent episodes.  The length of the specified \code{terminal} should
be equal to the number of subjects, or number of data rows.  In the
latter case, each subject may have at most one positive entry of
\code{terminal} at the last recurrent episode.}

\item{origin}{The time origin of each subject.  If a scalar value is
specified, all subjects will have the same origin at the specified
value.  The length of the specified \code{origin} should be equal to the
number of subjects, or number of data rows.  In the latter case,
different subjects may have different origins.  However, one subject
must have the same origin.  In addition to numeric values, \code{Date}
and \code{difftime} are also supported and converted to numeric values.}

\item{check}{A character value specifying how to perform the checks for
recurrent event data.  Errors or warnings will be thrown, respectively,
if the \code{check} is specified to be \code{"hard"} (by default) or
\code{"soft"}.  If \code{check = "none"} is specified, no data checking
procedure will be run.}

\item{...}{Other arguments for future usage.  A warning will be thrown if
any invalid argument is specified.}
}
\value{
An \code{Recur} object.
}
\description{
Create an S4 class object that represents formula response for recurrent
event data with optional checking procedures embedded.
}
\details{
This is a successor function of the deprecated function \code{Survr}.  See
the vignette by `vignette("reda-Recur")` for details.
}
\examples{
library(reda)
with(valveSeats, Recur(Days, ID))
with(valveSeats, Recur(Days, ID, No.))
with(valveSeats, Recur(Days, ID, No., terminal = 1))
with(valveSeats, Recur(Days, ID, No., origin = 10))
}
