% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcfDiff.R
\name{mcfDiff}
\alias{mcfDiff}
\alias{-,mcf.formula,mcf.formula-method}
\alias{mcfDiff.test}
\title{Comparing Two-Sample MCFs}
\usage{
mcfDiff(mcf1, mcf2 = NULL, level = 0.95, ...)

mcfDiff.test(
  mcf1,
  mcf2 = NULL,
  testVariance = c("robust", "Poisson", "none"),
  ...
)
}
\arguments{
\item{mcf1}{A \code{mcf.formula} object representing the MCF for one or two
groups.}

\item{mcf2}{An optional second \code{mcf.formula} object or \code{NULL}.}

\item{level}{A numeric value indicating the confidence level required. The
default value is 0.95.}

\item{...}{Other arguments passed to \code{mcfDiff.test}.}

\item{testVariance}{A character string specifying the method for computing
the variance estimate for the pseudo-score test statistic proposed by
Cook, Lawless, and Nadeau (1996). The applicable options include
\code{"robust"} (default) for an estimate robust to departures from
Poisson assumptions, \code{"Poisson"} for an estimate for Poisson
process, and \code{"none"} for not performing any test (if only the
difference estimates are of interest in \code{mcfDiff}).}
}
\value{
The function \code{mcfDiff} returns a \code{mcfDiff} object (of S4 class)
that contains the following slots:
\itemize{
\item \code{call}: Function call.
\item \code{MCF}: Estimated Mean cumulative function Difference at each time
point.
\item \code{origin}: Time origins of the two groups.
\item \code{variance}: The method used for variance estimates.
\item \code{logConfInt}: A logical value indicating whether normality is
assumed for \code{log(MCF)} instead of MCF itself.  For \code{mcfDiff}
object, it is always \code{FALSE}.
\item \code{level}: Confidence level specified.
\item \code{test}: A \code{mcfDiff.test} object for the hypothesis test
results.
}

The function \code{mcfDiff.test} returns a \code{mcfDiff.test} object (of S4
class) that contains the following slots:
\itemize{
\item \code{.Data}: A numeric matrix (of two rows and five columns) for
hypothesis testing results.
\item \code{testVariance}: A character string (or vector of length one)
indicating the method used for the variance estimates of the test statistic.
}
}
\description{
This function estimates the sample MCF difference between two groups. Both
the point estimates and the confidence intervals are computed (Lawless and
Nadeau 1995). The two-sample pseudo-score test proposed by Cook, Lawless,
and Nadeau (1996) is also performed by default.
}
\details{
The function \code{mcfDiff} estimates the two-sample MCFs' difference and
internally calls function \code{mcfDiff.test} to perform the pseudo-score
tests by default. A \code{-} method is available as a simple wrapper for the
function \code{mcfDiff} for comparing two-sample MCFs from two
\code{mcf.formula} objects. For instance, suppose \code{mcf1} and
\code{mcf2} are \code{mcf.formula} objects, each of which represents the
sample MCF estimates for one group. The function call \code{mcf1 - mcf2} is
equivalent to \code{mcfDiff(mcf1, mcf2)}.

The null hypothesis of the two-sample pseudo-score test is that there is no
difference between the two sample MCFs, while the alternative hypothesis
suggests a difference.  The test is based on a family of test statistics
proposed by Lawless and Nadeau (1995). The argument \code{testVariance}
specifies the method for computing the variance estimates of the test
statistics under different model assumption. See the document of argument
\code{testVariance} for all applicable options.  For the variance estimates
robust to departures from Poisson process assumption, both constant weight
and the linear weight function (with scaling) suggested in Cook, Lawless,
and Nadeau (1996) are implemented. The constant weight is powerful in cases
where the two MCFs are approximately proportional to each other. The linear
weight function is originally \code{a(u) = t - u}, where \code{u} represents
the time variable and \code{t} is the first time point when the risk set of
either group becomes empty. It is further scaled by \code{1 / t} for test
statistics invariant to the unit of measurement of the time variable.  The
linear weight function puts more emphasis on the difference at earily times
than later times and is more powerful for cases where the MCFs are no longer
proportional to each other, but not crossing. Also see Cook and Lawless
(2007, Section 3.7.5) for more details.
}
\examples{
## See examples given for function mcf.
}
\references{
Lawless, J. F., & Nadeau, C. (1995). Some Simple Robust Methods for the
Analysis of Recurrent Events. \emph{Technometrics}, 37(2), 158--168.

Cook, R. J., Lawless, J. F., & Nadeau, C. (1996). Robust Tests for Treatment
Comparisons Based on Recurrent Event Responses. \emph{Biometrics}, 52(2),
557--571.

Cook, R. J., & Lawless, J. (2007). \emph{The Statistical Analysis of
Recurrent Events}.  Springer Science & Business Media.
}
