% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{Survr}
\alias{Survr}
\title{Formula Response for Recurrent Event Data}
\usage{
Survr(ID, time, event)
}
\arguments{
\item{ID}{Identificator of each subject.}

\item{time}{Time of reccurence event or censoring.}

\item{event}{The status indicator, 0 = censored, 1 = event.}
}
\description{
\code{Survr} is an S3 class that represents
formula response for recurrent event data
modeled by methods based on counts and rate function.
The last letter 'r' in 'Survr' represents 'rate'.
}
\details{
This is a similar function to \code{Survr} in package
\pkg{survrec} but with a better embedded checking procedure for
recurrent event data modeled by methods
based on counts and rate function.
The checking rules include that
\itemize{
    \item Identification of each subject cannot be missing.
    \item Event indicator must be coded as 0 (censored) or 1 (event).
    \item Event time and censoring time cannot be missing.
    \item Each subject must have one and only one censoring time.
    \item Event time cannot not be later than censoring time.
}
}
\seealso{
\code{\link{rateReg}} for model fitting.
}

