% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map.points}
\alias{map.points}
\title{Map recorded distribution of species.}
\usage{
map.points(longlat, layers, eval = TRUE)
}
\arguments{
\item{longlat}{Matrix of longitude and latitude or eastness and northness (two columns in this order) of each occurrence record.}

\item{layers}{Raster* object as defined by package raster. Any raster with the relevant extent and cell size can be used.}

\item{eval}{If TRUE, build a matrix with EOO and AOO calculated from occurrence records only.}
}
\value{
One raster object and, if EVAL = TRUE, a matrix with EOO and AOO.
}
\description{
Mapping of all cells where the species is known to occur.
}
\details{
To be used if either information on the species is very scarce (and it is not possible to model the species distribution) or, on the contrary, complete (and there is no need to model the distribution).
}
\examples{
records = red.examples("red.records")
layers = red.examples("red.layers")
terra::plot(map.points(records, layers, eval = FALSE))
points(records)
}
