% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_from_xy.R
\name{add_from_x}
\alias{add_from_x}
\alias{add_from_y}
\title{Add variables from data sets to pairs}
\usage{
add_from_x(pairs, ...)

add_from_y(pairs, ...)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{...}{a set of option of the form \code{newvarname = "varname"}, where
\code{varname} is a column in \code{x} or \code{y}.}
}
\value{
A \code{pairs} object which contains all column of the original \code{pairs}
with the new columns added to it. An error is generated when it is attempted
to add variables that already exist in pairs.
}
\description{
Add variables from data sets to pairs
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
pairs <- compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
pairs <- add_from_x(pairs, id_x = "id")
pairs <- add_from_y(pairs, id_y = "id")
pairs$true_match <- pairs$id_x == pairs$id_y

}
