% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_weights.R
\name{case-weight-helpers}
\alias{case-weight-helpers}
\alias{get_case_weights}
\alias{averages}
\alias{medians}
\alias{variances}
\alias{correlations}
\alias{covariances}
\alias{pca_wts}
\alias{are_weights_used}
\title{Helpers for steps with case weights}
\usage{
get_case_weights(info, .data)

averages(x, wts = NULL, na_rm = TRUE)

medians(x, wts = NULL)

variances(x, wts = NULL, na_rm = TRUE)

correlations(x, wts = NULL, use = "everything", method = "pearson")

covariances(x, wts = NULL, use = "everything", method = "pearson")

pca_wts(x, wts = NULL)

are_weights_used(wts, unsupervised = FALSE)
}
\arguments{
\item{info}{A data frame from the \code{info} argument within steps}

\item{.data}{The training data}

\item{x}{A numeric vector or a data frame}

\item{wts}{A vector of case weights}

\item{na_rm}{A logical value indicating whether \code{NA}
values should be removed during computations.}

\item{use}{Used by \code{\link[=correlations]{correlations()}} or \code{\link[=covariances]{covariances()}} to pass argument to
\code{\link[=cor]{cor()}} or \code{\link[=cov]{cov()}}}

\item{method}{Used by \code{\link[=correlations]{correlations()}} or \code{\link[=covariances]{covariances()}} to pass argument to
\code{\link[=cor]{cor()}} or \code{\link[=cov]{cov()}}}

\item{unsupervised}{Can the step handle unsupervised weights}
}
\description{
These functions can be used to do basic calculations with or without case
weights.
}
\details{
\code{\link[=get_case_weights]{get_case_weights()}} is designed for developers of recipe steps, to return
a column with the role of "case weight" as a vector.

For the other functions, rows with missing case weights are removed from
calculations.

For \code{averages()} and \code{variances()}, missing values in the data (\emph{not} the
case weights) only affect the calculations for those rows. For
\code{correlations()}, the correlation matrix computation first removes rows
with any missing values (equal to the "complete.obs" strategy in
\code{\link[stats:cor]{stats::cor()}}).

\code{are_weights_used()} is designed for developers of recipe steps and is used
inside print method to determine how printing should be done.
}
