% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe.R
\name{bake}
\alias{bake}
\alias{bake.recipe}
\alias{bake.recipe}
\title{Apply a Trained Data Recipe}
\usage{
bake(object, ...)

\method{bake}{recipe}(object, newdata, ..., composition = "tibble")
}
\arguments{
\item{object}{A trained object such as a \code{\link[=recipe]{recipe()}} with at least
one preprocessing operation.}

\item{...}{One or more selector functions to choose which variables will be
returned by the function. See \code{\link[=selections]{selections()}} for more details.
If no selectors are given, the default is to use
\code{\link[=everything]{everything()}}.}

\item{newdata}{A data frame or tibble for whom the preprocessing will be
applied.}

\item{composition}{Either "tibble", "matrix", or "dgCMatrix" for the
format of the processed data set. Note that all computations
during the baking process are done in a non-sparse format. Also,
note that this argument should be called \strong{after} any selectors
and the selectors should only resolve to numeric columns
(otherwise an error is thrown).}
}
\value{
A tibble, matrix, or sparse matrix that may have different
columns than the original columns in \code{newdata}.
}
\description{
For a recipe with at least one preprocessing operations that has been trained by
\code{\link[=prep.recipe]{prep.recipe()}}, apply the computations to new data.
}
\details{
\code{\link[=bake]{bake()}} takes a trained recipe and applies the
operations to a data set to create a design matrix.

If the original data used to train the data are to be
processed, time can be saved by using the \code{retain = TRUE} option
of \code{\link[=prep]{prep()}} to avoid duplicating the same operations. With this
option set, \code{\link[=juice]{juice()}} can be used instead of \code{bake} with
\code{newdata} equal to the training set.

Also, any steps with \code{skip = TRUE} will not be applied to the
data when \code{bake} is invoked. \code{\link[=juice]{juice()}} will always have all
of the steps applied.
}
\seealso{
\code{\link[=recipe]{recipe()}}, \code{\link[=juice]{juice()}}, \code{\link[=prep]{prep()}}
}
\author{
Max Kuhn
}
\concept{
preprocessing model_specification
}
\keyword{datagen}
