% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selections.R
\name{recipes_eval_select}
\alias{recipes_eval_select}
\title{Evaluate a selection with tidyselect semantics specific to recipes}
\usage{
recipes_eval_select(quos, data, info, ..., allow_rename = FALSE)
}
\arguments{
\item{quos}{A list of quosures describing the selection. This is generally
the \code{...} argument of your step function, captured with \code{\link[=ellipse_check]{ellipse_check()}}
or \code{\link[rlang:nse-defuse]{rlang::enquos()}} and stored in the step object as the \code{terms} element.}

\item{data}{A data frame to use as the context to evaluate the selection in.
This is generally the \code{training} data passed to the \code{\link[=prep]{prep()}} method
of your step.}

\item{info}{A data frame of term information describing each column's type
and role for use with the recipes selectors. This is generally the \code{info}
data passed to the \code{\link[=prep]{prep()}} method of your step.}

\item{...}{These dots are for future extensions and must be empty.}

\item{allow_rename}{Should the renaming syntax \code{c(foo = bar)} be allowed?
This is rarely required, and is currently only used by \code{\link[=step_select]{step_select()}}.
It is unlikely that your step will need renaming capabilities.}
}
\value{
A named character vector containing the evaluated selection. The names are
always the same as the values, except when \code{allow_rename = TRUE}, in which
case the names reflect the new names chosen by the user.
}
\description{
\code{recipes_eval_select()} is a recipes specific variant of
\code{\link[tidyselect:eval_select]{tidyselect::eval_select()}} enhanced with the ability to recognize recipes
selectors, such as \code{\link[=all_numeric_predictors]{all_numeric_predictors()}}. See \link{selections}
for more information about the unique recipes selectors.

This is a developer tool that is only useful for creating new recipes steps.
}
\examples{
library(rlang)
library(modeldata)
data(scat)

rec <- recipe(Species ~ ., data = scat)

info <- summary(rec)
info

quos <- quos(all_numeric_predictors(), where(is.factor))

recipes_eval_select(quos, scat, info)
}
