make.controls <- function( PopulationAtRisk, cases, ctc, requireAllGroups = FALSE )
  {
    if( class(PopulationAtRisk) != "PopulationAtRisk" )
      stop("This function has to be called with a 'PopulationAtRisk' object generated by 'build.population()'.")


    ## Zugriff vereinfachen
    PaR <- PopulationAtRisk
    cf <- ctc
    
    ## 
    groups <- PaR[[4]][,1]
    ngroups <- length( groups )
    ncases <- length(cases[,1])
    ncontrols <- cf * ncases
    pop.percentages <- PaR[[4]][,3]

    groupcontrols <- rmultinom( n = 1, size = ncontrols, prob = pop.percentages)

    if ( requireAllGroups == TRUE ){
      while ( length( which(groupcontrols == 0) > 0 ) ){
        warning("There were nonrepresented groups in the controls. The simulation was rejected and repeated.
 If this happens often, your results may be biased.")
        groupcontrols <- rmultinom( n = 1, size = ncontrols, prob = pop.percentages)
      }
    }
    
    ## Finden aller Hauptfaktoren als character()
    ## auer der 0:
    main <- unique( unlist( strsplit( as.character(groups), ":" ) ) )[-1]

    ## Jetzt knne wir den data.frame() einrichten mit der Abhngigen immer 1 und vorerst
    ## allen Exogenen gleich 0:

    endog <- as.character( PaR[[1]][[2]] ) # Name der Endogenen
    controls <- data.frame( rep(0,ncontrols) ) # Variable mit 1en schaffen
    names(controls) <- endog # Variable korrekt benennen
    for ( i in 1:length(main) )
      { # Die brigen Variablen anlegen
        var.name <- main[i] # Name der neu anzulegenden Variable.
        df.names <- names(controls) # Bisherige Variablennamen
        controls <- data.frame( controls, assign("new",0) ) # Eine neue Variable 'new' = 0 zum df hinzufgen.
        names(controls) <- c(df.names,var.name) # 'new' in den passenden Namen umbenennen.
      }
    ## Jetzt existiert der data.frame() der Flle, allerdings noch ohne die
    ## korrekten Ausprgungen der Exogenen.
    ## Fr die ersten groupcases[1] Flle sind alle Ausprgungen 0, d.h.
    ## wir fangen erst mit dem darauffolgenden Fall an, Einsen in die
    ## Exogenen zu schreiben:
    startindex <- groupcontrols[1] + 1

    ## Fr jede der folgenden Grupppen mssen wir nun auf Basis der Gruppennamen
    ## die Exogenen fllen.
    for ( i in 2:length(groups) )
      {
        endindex <- startindex+groupcontrols[i] - 1
        exog <- unlist(strsplit( as.character(groups[i]), ":")) # Auslesen der in der aktuellen Gruppe Eins zu setzenden Hauptfaktoren
        controls[ startindex:endindex, exog ] <- 1
        startindex <- startindex+groupcontrols[i]
      }
    return (controls)
  }
