% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdregioninfo.R
\name{ebirdregioninfo}
\alias{ebirdregioninfo}
\title{Region info}
\usage{
ebirdregioninfo(loc, format = "full", key = NULL, ...)
}
\arguments{
\item{loc}{The location code to be checked. A single location only.}

\item{format}{Different options for displaying hierarchy of the region's name: [nameonly|namequal|detailed|detailednoqual|revdetailed|full], defaults to full.}

\item{key}{ebird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an 
environment variable called \code{EBIRD_KEY}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
A data frame containing:

"region": name of the region, varies depending on value of "format" provided

"minX", "maxX", "minY", "minY": lat/long bounds of the region
}
\description{
Region info
}
\examples{
\dontrun{
ebirdregioninfo("US")
ebirdregioninfo("CA-BC-GV")
}
}
\references{
\url{http://ebird.org/}
}
\author{
Sebastian Pardo \email{sebpardo@gmail.com},
   Andy Teucher \email{andy.teucher@gmail.com}
}
