library(rearrr)
context("create_dimming_fn()")

test_that("create_dimming_fn()", {

  # We can't check function definitions when running covr::*
  if (requireNamespace("covr", quietly = TRUE))
    testthat::skip_if(covr::in_covr())

  # Generate expectations for 'create_dimming_fn'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = create_dimming_fn,
  #   args_values = list(
  #     "numerator" = list(1, 0, NA),
  #     "exponent" = list(2, 1, 0, -3, NA),
  #     "add_to_distance" = list(1, -1, 0, NA)
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'create_dimming_fn'                                              ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 1)
  # Testing is function
  expect_true(
    is.function(output_19148))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_19148),
    c("x", "d"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    paste0(deparse(output_19148), collapse = ""),
    paste0(c("function (x, d) ", "{", "    x * (numerator/((add_to_distance + d)^exponent))",
      "}"), collapse = ""),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 0, exponent = ...
  # Changed from baseline: numerator = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- create_dimming_fn(numerator = 0, exponent = 2, add_to_distance = 1)
  # Testing is function
  expect_true(
    is.function(output_19370))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_19370),
    c("x", "d"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_19370),
    c("function (x, d) ", "{", "    x * (numerator/((add_to_distance + d)^exponent))",
      "}"),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = NA, exponent =...
  # Changed from baseline: numerator = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(create_dimming_fn(numerator = NA, exponent = 2, add_to_distance = 1), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'numerator': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = NULL, exponent...
  # Changed from baseline: numerator = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(create_dimming_fn(numerator = NULL, exponent = 2, add_to_distance = 1), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'numerator': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: exponent = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_16417 <- create_dimming_fn(numerator = 1, exponent = 1, add_to_distance = 1)
  # Testing is function
  expect_true(
    is.function(output_16417))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_16417),
    c("x", "d"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_16417),
    c("function (x, d) ", "{", "    x * (numerator/((add_to_distance + d)^exponent))",
      "}"),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: exponent = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- create_dimming_fn(numerator = 1, exponent = 0, add_to_distance = 1)
  # Testing is function
  expect_true(
    is.function(output_15190))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_15190),
    c("x", "d"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_15190),
    c("function (x, d) ", "{", "    x * (numerator/((add_to_distance + d)^exponent))",
      "}"),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: exponent = -3
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- create_dimming_fn(numerator = 1, exponent = -3, add_to_distance = 1)
  # Testing is function
  expect_true(
    is.function(output_17365))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_17365),
    c("x", "d"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_17365),
    c("function (x, d) ", "{", "    x * (numerator/((add_to_distance + d)^exponent))",
      "}"),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: exponent = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(create_dimming_fn(numerator = 1, exponent = NA, add_to_distance = 1), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'exponent': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: exponent = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(create_dimming_fn(numerator = 1, exponent = NULL, add_to_distance = 1), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'exponent': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: add_to_distance = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = -1)
  # Testing is function
  expect_true(
    is.function(output_17050))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_17050),
    c("x", "d"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_17050),
    c("function (x, d) ", "{", "    x * (numerator/((add_to_distance + d)^exponent))",
      "}"),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: add_to_distance = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = 0)
  # Testing is function
  expect_true(
    is.function(output_14577))
  # Testing argument names and default values
  expect_equal(
    xpectr::simplified_formals(output_14577),
    c("x", "d"),
    fixed = TRUE)
  # Testing function definition
  expect_equal(
    deparse(output_14577),
    c("function (x, d) ", "{", "    x * (numerator/((add_to_distance + d)^exponent))",
      "}"),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: add_to_distance = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = NA), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_to_distance': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing create_dimming_fn(numerator = 1, exponent = ...
  # Changed from baseline: add_to_distance = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(create_dimming_fn(numerator = 1, exponent = 2, add_to_distance = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'add_to_distance': Must be of type 'number', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'create_dimming_fn'                                     ####
  #


})



